import os
import django

# Setup Django environment
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'vristo.settings')
django.setup()

from django.db import connections
from main.models.UserProfile import UserProfile
from main.models.HealthCamp import Participant, ServiceChoice, HealthService


def migrate_data():
    old_db = connections['old_db']

    with old_db.cursor() as cursor:
        # Migrate UserProfile data
        for profile in UserProfile.objects.using('old_db').all():
            if not UserProfile.objects.filter(user_id=profile.user_id).exists():
                profile.save(using='default')

        # Migrate Participant data
        for participant in Participant.objects.using('old_db').all():
            if not Participant.objects.filter(email=participant.email).exists():
                participant.save(using='default')

        # Migrate ServiceChoice data
        for service in ServiceChoice.objects.using('old_db').all():
            if not ServiceChoice.objects.filter(service_title=service.service_title).exists():
                service.save(using='default')

        # Migrate HealthService data
        for health_service in HealthService.objects.using('old_db').all():
            if not HealthService.objects.filter(participant_id=health_service.participant_id, service_id=health_service.service_id).exists():
                health_service.save(using='default')

    print("Data migration completed successfully without duplicates.")

if __name__ == "__main__":
    migrate_data()
