
import io
import re
import csv
import json
import logging
import smtplib
import openpyxl
import traceback
from io import BytesIO
from xhtml2pdf import pisa
from decimal import Decimal
from django.views import View
from bs4 import BeautifulSoup
from collections import Counter
from django.conf import settings
from reportlab.lib import colors
from django.utils import timezone
from smtplib import SMTPException
from django.contrib import messages
from django.core.cache import cache
from collections import defaultdict
from reportlab.pdfgen import canvas
from datetime import datetime, date
from reportlab.lib.units import inch
from django.utils.text import slugify
from django.templatetags.static import static
from django.utils.encoding import force_bytes
from django.core.serializers import serialize
from django.urls import reverse_lazy, reverse
from django.db import IntegrityError,transaction
from django.contrib.auth.models import User, Group
from django.template.loader import render_to_string
from django.core.files.storage import FileSystemStorage
from django.db.models.functions import TruncYear, Concat
from django.contrib.auth.forms import PasswordChangeForm
from openpyxl.chart import BarChart, Reference, PieChart
from openpyxl.styles import Font, Alignment, PatternFill
from openpyxl.utils import get_column_letter
from django.utils.dateparse import parse_datetime, parse_date
from django.db.models import Sum, Count, F, Q, Value, CharField
from django.shortcuts import render, get_object_or_404, redirect
from django.views.decorators.csrf import csrf_exempt,csrf_protect
from django.core.exceptions import ValidationError, ObjectDoesNotExist
from django.core.paginator import Paginator, EmptyPage, PageNotAnInteger
from django.contrib.auth.decorators import user_passes_test,login_required
from django.utils.http import urlsafe_base64_encode, urlsafe_base64_decode
from django.views.decorators.http import require_http_methods, require_POST
from django.contrib.auth.tokens import PasswordResetTokenGenerator,default_token_generator
from django.core.mail import EmailMultiAlternatives, EmailMessage, get_connection, send_mail
from django.http import JsonResponse, HttpResponseRedirect, HttpResponse, HttpResponseNotAllowed
from django.contrib.auth import authenticate, login, logout, get_user_model, update_session_auth_hash
from reportlab.lib.styles import getSampleStyleSheet, ParagraphStyle
from reportlab.lib.pagesizes import A4, A3, A5, legal, letter, B4, B5, letter, landscape
from reportlab.platypus import SimpleDocTemplate, Paragraph, Table, TableStyle, PageBreak

from .models.Note import Note
from .models.Minutes import Minutes
from .models.WebData import WebData
from .models.calendar import Calendar
from .models.UserFiles import UserFile
from .models.CampItems import CampItem
from .models.Volunteer import Volunteer
from .models.ActivityLog import ActivityLog
from .models.PrivacyPolicy import PrivacyPolicy
from .models.SupportDocuments import SupportDocument
from .models.OrganizationType import OrganizationType
from .models.OrganizationFiles import OrganizationFile
from .models.TermsAndConditions import TermsAndConditions
from .models.VolunteerAgreement import VolunteerAgreement
from .models.PartnershipAgreement import PartnershipAgreement
from .models.ProgressReport import ProgressReport,UserReportStatus
from .models.UserProfile import UserProfile, generate_verification_token
from .models.AdminNotifications import AdminNotifications, NotificationReadBy
from .models.ContactAdminMessages import ContactAdminMessages, ContactDeveloper
from .models.PartneringOrganization import PartneringOrganization, PartnerOrganizationFeedbackAndSupport
from .models.Projects import Project, Beneficiary, CoreProblem, SolutionTree, Milestone, Result, Activity, Resource, Stakeholder, Indicator, Beneficiary
from .models.HealthCamp import Participant, WorkshopChoice, ParticipantWorkshop, ServiceChoice, HealthService, Feedback, TreePlanting

from .decorators import user_authenticated, has_manager_permissions, is_nurse, is_moderator, block_all_roles, is_partner, is_doctor,is_pharmacist

logger = logging.getLogger(__name__)


def unauthorized_access(request):
    return HttpResponse("You do not have permission to view this page.", status=403)

def auth_signin(request):
    latest_privacy_policy = PrivacyPolicy.objects.order_by('-uploaded_at').first()
    latest_terms_and_conditions = TermsAndConditions.objects.order_by('-uploaded_at').first()

    if request.method == 'POST':
        email = request.POST.get('email')
        password = request.POST.get('password')
        
        try:
            user = User.objects.get(email=email)
        except User.DoesNotExist:
            messages.error(request, 'No user found with this email address.')
            return render(request, 'backend/auth/signin.html')

        if user.check_password(password):
            if user.is_active:
                auth_user = authenticate(request, username=email, password=password)
                login(request, auth_user)
                messages.success(request, 'Login successful.')
                auth_view = AuthSignupView()
                ip_address = request.META.get('REMOTE_ADDR')
                user_agent = request.META.get('HTTP_USER_AGENT')
                auth_view.log_activity(
                    user,
                    'Login Success',
                    f'{user.first_name} {user.last_name} {user.email} logged in successfully at {timezone.now()}',
                    ip_address=ip_address,
                    user_agent=user_agent,
                ) 
                return redirect('users_account_page')
            else:
                messages.error(request, 'Your account is not active.')
        else:
            messages.error(request, 'Incorrect password.')

    context = {
        'latest_privacy_policy': latest_privacy_policy,
        'latest_terms_and_conditions': latest_terms_and_conditions,
        }

    return render(request, 'backend/auth/signin.html', context)

def auth_logout(request):
    auth_view = AuthSignupView()
    ip_address = request.META.get('REMOTE_ADDR')
    user_agent = request.META.get('HTTP_USER_AGENT')
    auth_view.log_activity(
        request.user,
        'Logout',
        f'User {request.user.first_name} {request.user.last_name} {request.user.email} logged out at {timezone.now()}',
        ip_address=ip_address,
        user_agent=user_agent,
    )
    logout(request)
    messages.success(request, 'You have logged out successfully.')
    return redirect('auth_signin')

@user_authenticated
def delete_account(request):
    if request.method == 'POST':
        user = request.user
        user.is_active = False
        user.save()
        messages.success(request, 'Your account has been deactivated.')
        auth_view = AuthSignupView()
        ip_address = request.META.get('REMOTE_ADDR')
        user_agent = request.META.get('HTTP_USER_AGENT')
        auth_view.log_activity(
            user,
            'Account Deactivate Success',
            f'{user.first_name} {user.last_name} {user.email} deactivated account successfully at {timezone.now()}',
            ip_address=ip_address,
            user_agent=user_agent,
        )
        return redirect('home')  
    return render(request, 'backend/users/profile.html')

class AuthSignupView(View):
    template_name = 'backend/auth/signup.html'
    

    def get(self, request):
        latest_privacy_policy = PrivacyPolicy.objects.order_by('-uploaded_at').first()
        latest_terms_and_conditions = TermsAndConditions.objects.order_by('-uploaded_at').first()
        context ={
            
            'latest_privacy_policy': latest_privacy_policy,
            'latest_terms_and_conditions': latest_terms_and_conditions,
        }
        return render(request, self.template_name, context)
        
    def post(self, request):
        first_name = request.POST.get('first_name')
        last_name = request.POST.get('last_name')
        phone = request.POST.get('phone')
        email = request.POST.get('email')
        password = request.POST.get('password')
        confirm_password = request.POST.get('confirm_password')
        

        if UserProfile.objects.filter(phone=phone).exists():
            messages.error(request, 'The phone number is registered with another account/user.')
            return redirect('auth_signup')

        if User.objects.filter(email=email).exists():
            messages.error(request, 'Email is already taken.')
            return redirect('auth_signup')

        if password != confirm_password:
            messages.error(request, 'Passwords do not match.')
            return redirect('auth_signup')
        
        phone_number_pattern = r'^(\+\d{1,3})?\d{9}$'
        if not re.match(phone_number_pattern, phone):
            messages.error(request, 'Business phone number should be in the format eg +254XXXXXXXXX.')
            return redirect('auth_signup')
        
        
        # Determine the selected role for logging
        
        
        user = User.objects.create_user(username=email, email=email, password=password, first_name=first_name, last_name=last_name)
        
        user_profile = UserProfile.objects.create(
            user=user,
            phone=phone,
            verification_token=generate_verification_token(),
            is_unknown=True
            
            
        )
        user.is_active = True
        user.save()
        
        
        ip_address = request.META.get('REMOTE_ADDR')
        user_agent = request.META.get('HTTP_USER_AGENT')
        self.log_activity(
            user,
            'Signup',
            f'User {first_name} {last_name}, {email}, created an account at {timezone.now()}',
            ip_address=ip_address,
            user_agent=user_agent,
            
        )
        try:
            webdata = WebData.objects.first()
            latest_privacy_policy = PrivacyPolicy.objects.order_by('-uploaded_at').first()
            latest_terms_and_conditions = TermsAndConditions.objects.order_by('-uploaded_at').first()
            

            verification_url = request.build_absolute_uri(reverse_lazy('verify_email', kwargs={'token': user_profile.verification_token}))
            email_subject = 'Kindly Finish Setting Up Your New Account'
            email_body = render_to_string('backend/auth/verification_email.html', {'verification_url': verification_url, 'first_name': first_name, 'last_name': last_name,'Organization': webdata.title,'latest_privacy_policy': latest_privacy_policy,'latest_terms_and_conditions': latest_terms_and_conditions,})
            verification_email = EmailMessage(
                email_subject,
                email_body,
                to=[email],
            )
            verification_email.content_subtype = 'html'
            verification_email.send()
            messages.success(request, 'Registration successful.')
        except smtplib.SMTPException as e:
            messages.error(request, f'Error sending verification email: {e}')
            traceback.print_exc()  
            self.log_activity(
                user,
                'VerificationError',
                f'Error sending verification email: {e} at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('auth_signup')
        except Exception as e:
            messages.error(request, 'An unexpected error occurred while sending the verification email.')
            traceback.print_exc()
            self.log_activity(
                user,
                'SignupError',
                f'Unexpected error during signup: {e} at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('auth_signup')
        return redirect('auth_signin')
    
    def log_activity(self, user, action, details=None, ip_address=None, user_agent=None, status_code=None, email=None):
        
        try:
            user_id = None if user is None else user.id
            activity_log = ActivityLog(
                user_id=user_id,
                action=action,
                timestamp=timezone.now(),
                details=details,
                ip_address=ip_address,
                user_agent=user_agent,
                status_code=status_code,
            )
            activity_log.save()
        except IntegrityError:
            
            pass


def verify_email(request, token):
    try:
        profile = UserProfile.objects.get(verification_token=token)
    except UserProfile.DoesNotExist:
        messages.error(request, 'Invalid verification token.')
        return redirect('Error')

    if profile.user.is_active:
        messages.info(request, 'You have been verified and account is active. Proceed to login')
        return redirect('Dashboard')

    profile.user.is_active = True
    profile.is_active = True
    profile.is_verified = True
    
    messages.success(request, 'You have been verified and account is active. Proceed to login')
    profile.user.save()
    profile.save()
    webdata = WebData.objects.first()
    
    
    email_subject = 'New User registered'
    email_body = render_to_string('backend/auth/Admin/Emails/New_User_ADMIN_EMAIL.html', {
        'first_name': profile.user.first_name,
        'last_name': profile.user.last_name,
        'email': profile.user.email,
        'phone': profile.phone,
        'Organization': webdata.title,
        
    })
    event_email = EmailMessage(
        email_subject,
        email_body,
        to=[settings.ADMIN_EMAIL],  
    )
    event_email.content_subtype = 'html'
    event_email.send()
    
    auth_view = AuthSignupView()
    ip_address = request.META.get('REMOTE_ADDR')
    user_agent = request.META.get('HTTP_USER_AGENT')
    auth_view.log_activity(
        profile.user,
        'EmailVerification',
        f'User {profile.user.first_name} verified email, {profile.user.email}, successfully at {timezone.now()}',
        ip_address=ip_address,
        user_agent=user_agent,
    )

    return redirect('Dashboard')

def resend_verification_email(request):
    if request.method == 'POST':
        email = request.POST.get('email')

        try:
            user = UserProfile.objects.get(email=email)
            profile = UserProfile.objects.get(user=user)

            if user.is_active:
                messages.info(request, 'Your email has already been verified.')
                return redirect('Success')

            verification_url = request.build_absolute_uri(reverse_lazy('verify_email', kwargs={'token': profile.verification_token}))
            email_subject = 'Resend: Kindly Finish Setting Up Your New Account'
            email_body = render_to_string('backend/auth/verification_email.html', {'verification_url': verification_url})
            verification_email = EmailMessage(
                email_subject,
                email_body,
                to=[email],
            )
            verification_email.content_subtype = 'html'
            verification_email.send()

            messages.success(request, 'Verification email has been resent. Please check your email.')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                user,
                'ResendVerificationEmail',
                f'User {user.first_name} {user.last_name} {user.email} resent verification email successfully at {timezone.now()}, to {email}',
                ip_address=ip_address,
                user_agent=user_agent,
            )

        except User.DoesNotExist:
            messages.error(request, 'No user with this email address.')
        except User.DoesNotExist:
            messages.error(request, 'User profile not found.')

    return redirect('wait_screen')

def auth_wait_screen(request):
    return render(request, 'backend/auth/waitscreen.html')

@user_authenticated
def change_password(request):
    if request.method == 'POST':
        form = PasswordChangeForm(request.user, request.POST)
        if form.is_valid():
            try:
                user = form.save()
                update_session_auth_hash(request, user)
                messages.success(request, 'Your password was successfully updated!')
                auth_view = AuthSignupView()
                ip_address = request.META.get('REMOTE_ADDR')
                user_agent = request.META.get('HTTP_USER_AGENT')
                auth_view.log_activity(
                    user,
                    'Password Change Success',
                    f'{request.user.first_name} {request.user.last_name} {request.user.email} changed Password successfully at {timezone.now()}',
                    ip_address=ip_address,
                    user_agent=user_agent,
                )
                logout(request)
                messages.info(request, 'You have been logged out. Please sign in again with new credentials.')
                return redirect('auth_signin')
                
            except Exception as e:
                messages.error(request, f'Error changing password: {str(e)}')
                auth_view = AuthSignupView()
                ip_address = request.META.get('REMOTE_ADDR')
                user_agent = request.META.get('HTTP_USER_AGENT')
                auth_view.log_activity(
                    request.user,
                    'PasswordChangeFailed',
                    f'Failed password change attempt for user {request.user.first_name} {request.user.last_name} {request.user.email} at {timezone.now()}',
                    ip_address=ip_address,
                    user_agent=user_agent,
                )
        else:
            
            for field, errors in form.errors.items():
                for error in errors:
                    messages.error(request, f'Error in {field}: {error}')

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'PasswordChangeFailed',
                f'Failed password change attempt for user {request.user.first_name} {request.user.last_name} {request.user.email} at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
    else:
        form = PasswordChangeForm(request.user)

    return render(request, 'backend/auth/change_password.html', {'form': form})

class AuthEmailPasswordResetLinkView(View):
    template_name = 'backend/auth/email_password_reset_link_page.html'

    def get(self, request):
        return render(request, self.template_name)

    def post(self, request):
        email = request.POST.get('email')
        user = User.objects.filter(email=email).first()

        if user is not None:
            token_generator = PasswordResetTokenGenerator()
            token = token_generator.make_token(user)
            uidb64 = urlsafe_base64_encode(force_bytes(user.pk))
            reset_link = reverse('password_reset_confirm', kwargs={'uidb64': uidb64, 'token': token})
            reset_url = request.build_absolute_uri(reset_link)
            context = {
                'username': user.username,
                'reset_url': reset_url
            }
            html_message = render_to_string('backend/auth/password_reset_email.html', context)
            subject = 'Password Reset'
            from_email = settings.EMAIL_HOST_USER
            to_email = [email]
            mail = EmailMultiAlternatives(subject, body=None, from_email=from_email, to=to_email)
            mail.attach_alternative(html_message, "text/html")
            mail.send()

            messages.success(request, 'We have sent you an email with a link to reset your password.')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                user,
                'Password Link Sent',
                f'Password Link Sent for user {user.first_name} {user.last_name}, {user.email} at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('Success') 

        else:
            messages.error(request, 'User with this email does not exist.')

        return render(request, self.template_name)

def auth_password_reset_confirm(request, uidb64, token):
    try:
        uid = urlsafe_base64_decode(uidb64).decode()
        user = User.objects.get(pk=uid)
    except (TypeError, ValueError, OverflowError, User.DoesNotExist):
        user = None

    if user is not None and PasswordResetTokenGenerator().check_token(user, token):
        if request.method == 'POST':
            new_password1 = request.POST.get('new_password1')
            new_password2 = request.POST.get('new_password2')
            if new_password1 == new_password2:
                user.set_password(new_password1)
                user.save()
                user = authenticate(username=user.username, password=new_password1)
                login(request, user)
                messages.success(request, 'Your password has been successfully reset.')
                auth_view = AuthSignupView()
                ip_address = request.META.get('REMOTE_ADDR')
                user_agent = request.META.get('HTTP_USER_AGENT')
                auth_view.log_activity(
                    user,
                    'Password Reset has been Confirmed',
                    f'Password Reset for user {user.first_name} {user.last_name}, {user.email} at {timezone.now()}',
                    ip_address=ip_address,
                    user_agent=user_agent,
                )
                return redirect('Dashboard')
            else:
                messages.error(request, 'The two password fields didn\'t match.')
        return render(request, 'backend/auth/change_password.html')
    else:
        messages.error(request, 'Invalid password reset link.')
        return redirect('email_password_reset_link')

def Success(request):
    return render(request, 'backend/auth/Success.html')

def Error(request):
    return render(request, 'backend/auth/Error.html')

def auth_verification_complete(request):
    return render(request, 'backend/auth/verification_complete.html')

def auth_verification_failed(request):
    return render(request, 'backend/auth/verification_failed.html')

def emailreset(request):
    return render(request, 'backend/auth/password_reset_email.html')

def emailverification(request):
    return render(request, 'backend/auth/verification_email.html')

def maintenance(request):
    webdata = WebData.objects.first()
    latest_privacy_policy = PrivacyPolicy.objects.order_by('-uploaded_at').first()
    latest_terms_and_conditions = TermsAndConditions.objects.order_by('-uploaded_at').first()
    
    context = {
    "webdata": webdata,
    "latest_privacy_policy":latest_privacy_policy,
    "latest_terms_and_conditions":latest_terms_and_conditions,
    }

    return render(request, 'backend/pages/maintenence.html', context)

def custom_404_view(request, exception):
    return render(request, "backend/pages/error404.html", {})

def custom_500_view(request):
    return render(request, "backend/pages/error500.html", {}, status=500)


@user_authenticated

def dashboard(request):
    webdata = WebData.objects.first()
    projects = Project.objects.all()
    minutes = Minutes.objects.all()
    user_profile = request.user.userprofile
    org_files = OrganizationFile.objects.all()
    partners = PartneringOrganization.objects.all()
    user_list = UserProfile.objects.filter(is_verified=True)
    volunteer_list = Volunteer.objects.order_by('-date_applied')[:7]
    latest_privacy_policy = PrivacyPolicy.objects.order_by('-uploaded_at').first()
    latest_volunteer_agreement = VolunteerAgreement.objects.order_by('-uploaded_at').first()
    latest_terms_and_conditions = TermsAndConditions.objects.order_by('-uploaded_at').first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    camp_items = CampItem.objects.all()
    
    workshop_choices = WorkshopChoice.objects.filter(workshop_officer=user_profile)
    service_choices = ServiceChoice.objects.filter(service_officer=user_profile)
    # Get all participant workshops related to the user's workshops
    participant_workshops = ParticipantWorkshop.objects.filter(workshop__in=workshop_choices)
    health_service_checkup = HealthService.objects.filter(service__in=service_choices)

    # Separate participants based on participation status
    participants_participated = participant_workshops.all()
    participants_checked = health_service_checkup.filter(participated=True)
    
    
    # Fetch participants who have participated but are not yet prescribed (viewed by doctors)
    participants_participated_not_prescribed = HealthService.objects.filter( participated=True, prescribed=False, medicated=False  ).select_related('participant', 'service')

    # Fetch participants who have both participated and are prescribed (viewed by doctors)
    participants_participated_and_prescribed = HealthService.objects.filter( participated=True, prescribed=True, medicated=False ).select_related('participant', 'service')
    
    participants_participated_and_prescribed_and_medicated = HealthService.objects.filter( participated=True, prescribed=True, medicated=True ).select_related('participant', 'service')
    
    # Count entities
    project_count = Project.objects.count()
    minutes_count = Minutes.objects.count()
    volunteer_list = Volunteer.objects.all()
    volunteer_count = volunteer_list.count()
    camp_items_count = CampItem.objects.count()
    participants_checked_count = participants_checked.count()
    organization_file_count = OrganizationFile.objects.count()
    partnering_org_count = PartneringOrganization.objects.count()
    user_count = UserProfile.objects.filter(is_verified=True).count()
    participants_participated_count = participants_participated.count()
    participants_participated_not_prescribed_count = participants_participated_not_prescribed.count()
    participants_participated_and_prescribed_count = participants_participated_and_prescribed.count()
    participants_participated_and_prescribed_and_medicated_count = participants_participated_and_prescribed_and_medicated.count()
    


    # Fetch the current user's files
    user_files = UserFile.objects.filter(user=user_profile)
    current_user_file_count = user_files.count()
    context = {
        "user_files": user_files,
        "user_count": user_count,
        'camp_items': camp_items,
        "service_choices":service_choices,
        "workshop_choices":workshop_choices,
        'participants_checked':participants_checked,
        'participants_checked_count':participants_checked_count,
        'participants_participated': participants_participated,
        'participants_participated_count': participants_participated_count,
        "participants_participated_not_prescribed": participants_participated_not_prescribed,
        "participants_participated_and_prescribed": participants_participated_and_prescribed,
        "participants_participated_not_prescribed_count":participants_participated_not_prescribed_count,
        "participants_participated_and_prescribed_count":participants_participated_and_prescribed_count,
        "participants_participated_and_prescribed_and_medicated":participants_participated_and_prescribed_and_medicated,
        "participants_participated_and_prescribed_and_medicated_count":participants_participated_and_prescribed_and_medicated_count,
        
        "project_count": project_count,
        "minutes_count": minutes_count,
        "volunteer_count":volunteer_count,
        "camp_items_count":camp_items_count,
        "partnering_org_count": partnering_org_count,
        "current_user_file_count": current_user_file_count,
        "organization_file_count": organization_file_count,
        
        "minutes":minutes,
        "webdata": webdata,
        "projects": projects,
        "partners": partners,
        "org_files": org_files,
        "user_list": user_list,
        "user_profile": user_profile,
        "notifications": notifications,
        "volunteer_list": volunteer_list,
        "latest_privacy_policy":latest_privacy_policy,
        "latest_volunteer_agreement":latest_volunteer_agreement,
        "latest_terms_and_conditions":latest_terms_and_conditions,
    }
    
    return render(request, 'backend/dashboard.html', context)

@is_partner
def download_monitoring_evaluation(request):
    response = HttpResponse(content_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')
    response['Content-Disposition'] = 'attachment; filename="camp_monitoring_evaluation.xlsx"'

    wb = openpyxl.Workbook()
    sheet = wb.active
    sheet.title = "Summary Report"

    # Define styles
    header_font = Font(bold=True, size=14, color="FFFFFF")
    header_fill = PatternFill(start_color="4F81BD", end_color="4F81BD", fill_type="solid")
    data_font = Font(size=12)
    data_fill = PatternFill(start_color="DDEBF7", end_color="DDEBF7", fill_type="solid")
    section_title_font = Font(bold=True, size=16, color="FFFFFF")
    section_title_fill = PatternFill(start_color="1F4E78", end_color="1F4E78", fill_type="solid")
    cell_wrap_alignment = Alignment(wrap_text=True, vertical='top')

    # Add and style "Summary Report" title
    sheet['A1'] = "Summary Report"
    sheet['A1'].font = section_title_font
    sheet['A1'].fill = section_title_fill
    sheet.merge_cells('A1:G1')  # Merging for a larger header area

    # Summary Report data
    summary_headers = ["Description", "Value"]
    sheet.append(summary_headers)
    for col_num, header in enumerate(summary_headers, start=1):
        cell = sheet.cell(row=2, column=col_num)
        cell.font = header_font
        cell.fill = header_fill
        cell.alignment = cell_wrap_alignment

    # Insert summary data
    summary_data = [
        ["Total Participants", Participant.objects.count()],
        ["Did Not Attend Any Service", Participant.objects.filter(health_services__isnull=True).count()],
        ["Prescribed but Not Medicated", HealthService.objects.filter(prescribed=True, medicated=False).count()],
        ["Total Prescribed", HealthService.objects.filter(prescribed=True).count()],
    ]
    for row_data in summary_data:
        sheet.append(row_data)
        for col_num, value in enumerate(row_data, start=1):
            cell = sheet.cell(row=sheet.max_row, column=col_num, value=value)
            cell.font = data_font
            cell.fill = data_fill
            cell.alignment = cell_wrap_alignment

    # Adjust column width based on the longest text
    for col_num in range(1, sheet.max_column + 1):
        max_length = 0
        column = get_column_letter(col_num)
        for row in sheet.iter_rows(min_col=col_num, max_col=col_num):
            for cell in row:
                try:
                    if len(str(cell.value)) > max_length:
                        max_length = len(cell.value)
                except:
                    pass
        adjusted_width = (max_length + 2)
        sheet.column_dimensions[column].width = adjusted_width

    # Leave a blank row for spacing
    sheet.append([])

    # Service Summary Report Section Header
    sheet.append(["Service Summary Report"])
    sheet['A{}'.format(sheet.max_row)].font = section_title_font
    sheet['A{}'.format(sheet.max_row)].fill = section_title_fill
    sheet.merge_cells(f'A{sheet.max_row}:G{sheet.max_row}')

    # Add headers for Service Summary Report table
    service_headers = [
        "Medical Service Title", "Nurse", "Nurse Role", "Total Participants",
        "Total Feedback Count", "Prescribed Count", "Medicated Count"
    ]
    sheet.append(service_headers)
    for col_num, header in enumerate(service_headers, start=1):
        cell = sheet.cell(row=sheet.max_row, column=col_num)
        cell.font = header_font
        cell.fill = header_fill
        cell.alignment = cell_wrap_alignment

    # Populate Service Summary Report data
    services = ServiceChoice.objects.all()
    for service in services:
        total_participants = HealthService.objects.filter(service=service).count()
        if total_participants == 0:
            continue
        
        service_officer = service.service_officer
        officer_role = (
            "Nurse" if service_officer.is_nurse else
            "Doctor" if service_officer.is_doctor else
            "Pharmacist" if service_officer.is_pharmacist else
            "Unknown"
        )
        row_data = [
            service.service_title,
            service_officer.user.get_full_name() if service_officer else "N/A",
            officer_role,
            total_participants,
            HealthService.objects.filter(service=service).exclude(Q(doctors_feedback="") | Q(pharmacist_feedback="")).count(),
            HealthService.objects.filter(service=service, prescribed=True).count(),
            HealthService.objects.filter(service=service, medicated=True).count()
        ]
        
        sheet.append(row_data)
        for col_num, value in enumerate(row_data, start=1):
            cell = sheet.cell(row=sheet.max_row, column=col_num, value=value)
            cell.font = data_font
            cell.fill = data_fill
            cell.alignment = cell_wrap_alignment
            

    # Adjust column width after populating data
    for col_num in range(1, sheet.max_column + 1):
        max_length = 0
        column = get_column_letter(col_num)
        for row in sheet.iter_rows(min_col=col_num, max_col=col_num):
            for cell in row:
                try:
                    if len(str(cell.value)) > max_length:
                        max_length = len(cell.value)
                except:
                    pass
        adjusted_width = (max_length + 2)
        sheet.column_dimensions[column].width = adjusted_width

    # Leave a blank row for spacing
    sheet.append([])

    # Most Common Statistics Section Header
    sheet.append(["Most Common Statistics"])
    sheet['A{}'.format(sheet.max_row)].font = section_title_font
    sheet['A{}'.format(sheet.max_row)].fill = section_title_fill
    sheet.merge_cells(f'A{sheet.max_row}:G{sheet.max_row}')

    # Most Common Statistics data with styled headers
    stats_headers = ["Statistic", "Most Common Value"]
    sheet.append(stats_headers)
    for col_num, header in enumerate(stats_headers, start=1):
        cell = sheet.cell(row=sheet.max_row, column=col_num)
        cell.font = header_font
        cell.fill = header_fill
        cell.alignment = cell_wrap_alignment

    # Calculate and add statistics data
    most_common_gender = Participant.objects.values('sex').annotate(count=Count('sex')).order_by('-count').first()['sex']
    most_common_age = Participant.objects.values('age').annotate(count=Count('age')).order_by('-count').first()['age']

    # Retrieve the top 7 most common conditions
    most_common_conditions = HealthService.objects.values('doctors_feedback').annotate(count=Count('doctors_feedback')).order_by('-count')[:7]
    most_common_condition_list = ", ".join([condition['doctors_feedback'] for condition in most_common_conditions])

    stats_data = [
        ["Most Common Gender", most_common_gender],
        ["Most Common Age", most_common_age],
        ["Top 7 Conditions Based on Feedback", most_common_condition_list]
    ]
    
    for row_data in stats_data:
        sheet.append(row_data)
        for col_num, value in enumerate(row_data, start=1):
            cell = sheet.cell(row=sheet.max_row, column=col_num, value=value)
            cell.font = data_font
            cell.fill = data_fill
            cell.alignment = cell_wrap_alignment
            
    # Collect gender data counts
    male_count = Participant.objects.filter(sex='Male').count()
    female_count = Participant.objects.filter(sex='Female').count()

    # Manually setting the starting row for the gender data
    gender_data_start_row = sheet.max_row + 2  # Separate it from previous data
    gender_data = [
        ["Male", male_count],
        ["Female", female_count],
    ]

    # Add headers and gender count data
    sheet.append(["Gender", "Count"])
    for col_num, header in enumerate(["Gender", "Count"], start=1):
        cell = sheet.cell(row=gender_data_start_row, column=col_num)
        cell.font = header_font
        cell.fill = header_fill
        cell.alignment = cell_wrap_alignment

    for row_data in gender_data:
        sheet.append(row_data)
        for col_num, value in enumerate(row_data, start=1):
            cell = sheet.cell(row=sheet.max_row, column=col_num, value=value)
            cell.font = data_font
            cell.fill = data_fill
            cell.alignment = cell_wrap_alignment

    # Collect age data counts
    age_data = Participant.objects.values('age').annotate(count=Count('age')).order_by('age')

    # Manually setting the starting row for the age data
    age_data_start_row = sheet.max_row + 2  # Separate it from gender data
    sheet.append(["Age", "Count"])
    for col_num, header in enumerate(["Age", "Count"], start=1):
        cell = sheet.cell(row=age_data_start_row, column=col_num)
        cell.font = header_font
        cell.fill = header_fill
        cell.alignment = cell_wrap_alignment

    # Add age count data
    for age_entry in age_data:
        age_row = [age_entry['age'], age_entry['count']]
        sheet.append(age_row)
        for col_num, value in enumerate(age_row, start=1):
            cell = sheet.cell(row=sheet.max_row, column=col_num, value=value)
            cell.font = data_font
            cell.fill = data_fill
            cell.alignment = cell_wrap_alignment

    # Adjust column width again to fit statistics
    for col_num in range(1, sheet.max_column + 1):
        max_length = 0
        column = get_column_letter(col_num)
        for row in sheet.iter_rows(min_col=col_num, max_col=col_num):
            for cell in row:
                try:
                    if len(str(cell.value)) > max_length:
                        max_length = len(cell.value)
                except:
                    pass
        adjusted_width = (max_length + 2)
        sheet.column_dimensions[column].width = adjusted_width

    # Leave a blank row for spacing
    sheet.append([])

   
    # Create a new sheet for Participants Who Did Not Attend Any Service
    sheet_no_service = wb.create_sheet("Participants Who were not seen by a Nurse")

    # Add title for the new sheet
    sheet_no_service['A1'] = "Participants Who were not seen by a Nurse"
    sheet_no_service['A1'].font = section_title_font
    sheet_no_service['A1'].fill = section_title_fill

    # Participants who did not attend any service
    participants_no_service = Participant.objects.filter(health_services__isnull=True)
    
    # Add headers for the table
    sheet_no_service.append([
        "Participant Name", "Age", "Sex", "Phone", "Email"
    ])

    # Write participants who did not attend any service
    for participant in participants_no_service:
        sheet_no_service.append([
            participant.name, participant.age, participant.sex, participant.phone, participant.email
        ])

    # Create a new sheet for Participants only seen by a Doctor (Possible Referral)
    sheet_prescribed_not_medicated = wb.create_sheet("Participants only seen by a Doctor")

    # Add title for the new sheet
    sheet_prescribed_not_medicated['A1'] = "Participants only seen by a Doctor (Possible Referral)"
    sheet_prescribed_not_medicated['A1'].font = section_title_font
    sheet_prescribed_not_medicated['A1'].fill = section_title_fill

    # Participants prescribed but not medicated (possible referral)
    participants_prescribed_not_medicated = HealthService.objects.filter(
        prescribed=True, medicated=False
    ).select_related('participant')  # To avoid hitting the database multiple times for each participant
    
    # Add headers for the table
    sheet_prescribed_not_medicated.append([
        "Participant Name", "Age", "Sex", "Phone", "Email", "Service Title", "Doctors Prescription"
    ])

    # Write participants prescribed but not medicated
    for health_service in participants_prescribed_not_medicated:
        participant = health_service.participant
        sheet_prescribed_not_medicated.append([
            participant.name, participant.age, participant.sex, participant.phone, participant.email,
            health_service.service.service_title, health_service.doctors_prescription if health_service.doctors_prescription else "N/A"
        ])
        
    # Create a new sheet for Participants Who Were Prescribed by Doctor and Medicated by Pharmacist
    sheet_prescribed_medicated = wb.create_sheet("Participants Prescribed by Doctor and Medicated by Pharmacist")

    # Add title for the new sheet
    section_title_font = Font(bold=True, size=16)
    section_title_fill = PatternFill(start_color="ADD8E6", end_color="ADD8E6", fill_type="solid")
    sheet_prescribed_medicated['A1'] = "Participants Who Were Prescribed by Doctor and Medicated by Pharmacist"
    sheet_prescribed_medicated['A1'].font = section_title_font
    sheet_prescribed_medicated['A1'].fill = section_title_fill

    # Define headers for this new sheet
    sheet_prescribed_medicated.append([
        "Participant Name", "Age", "Sex", "Phone", "Email", "Service Title", "Nurse",
        "Role", "Participant Results", "Nurse Feedback", 
        "Doctor's Prescription", "Pharmacist's Prescription", "Doctor's Feedback", 
        "Pharmacist's Feedback"
    ])

    # Fetch participants who were prescribed and medicated
    participants_prescribed_medicated = HealthService.objects.filter(
        prescribed=True, medicated=True
    ).select_related('participant', 'service', 'service__service_officer')

    # Write participant details in the new sheet
    for health_service in participants_prescribed_medicated:
        participant = health_service.participant
        service = health_service.service
        service_officer = service.service_officer
        officer_role = (
            "Nurse" if service_officer and service_officer.is_nurse else
            "Doctor" if service_officer and service_officer.is_doctor else
            "Pharmacist" if service_officer and service_officer.is_pharmacist else
            "Unknown"
        )

        # Add row with participant and service data
        sheet_prescribed_medicated.append([
            participant.name,
            participant.age,
            participant.sex,
            participant.phone,
            participant.email,
            service.service_title if service else "N/A",
            service_officer.user.get_full_name() if service_officer else "N/A",
            officer_role,
            health_service.participant_results if health_service.participant_results else "N/A",
            health_service.service_officer_officer_feedback if health_service.service_officer_officer_feedback else "N/A",
            health_service.doctors_prescription if health_service.doctors_prescription else "N/A",
            health_service.pharmacist_prescription if health_service.pharmacist_prescription else "N/A",
            health_service.doctors_feedback if health_service.doctors_feedback else "N/A",
            health_service.pharmacist_feedback if health_service.pharmacist_feedback else "N/A"
        ])

    # Add a detailed conclusion sheet with insights
    sheet_conclusion = wb.create_sheet("Conclusion")

    sheet_conclusion['A1'] = "Conclusion"
    sheet_conclusion['A1'].font = section_title_font
    sheet_conclusion['A1'].fill = section_title_fill

    # Add a summary with insights
    total_participants = Participant.objects.count()
    participants_no_service_count = participants_no_service.count()
    participants_prescribed_not_medicated_count = HealthService.objects.filter(prescribed=True, medicated=False).count()
    
    conclusion_text = (
        f"Total Participants: {total_participants}\n\n"
        f"Participants Who Did Not Attend Any Service: {participants_no_service_count}\n"
        f"Participants Prescribed but Not Medicated (Possible Referral): {participants_prescribed_not_medicated_count}\n\n"
        f"Insights:\n"
        f"- The total number of participants who attended at least one service is {total_participants - participants_no_service_count}.\n"
        f"- A significant number of participants, {participants_prescribed_not_medicated_count}, have been prescribed treatments but have not been medicated, which could indicate a need for referrals to ensure proper treatment.\n"
        f"- Service officers, including doctors and nurses, have been effective in managing participants, but feedback data shows a need for improvement in capturing detailed feedback.\n\n"
        f"Recommendations:\n"
        f"- Follow up with participants who have been prescribed but not medicated to ensure they receive appropriate treatment.\n"
        f"- Increase participation in services by identifying barriers that prevent attendees from participating."
    )
    
    sheet_conclusion['A2'] = conclusion_text
    sheet_conclusion['A2'].font = Font(size=12)

    # Save the workbook and send it as a response
    wb.save(response)
    return response

@login_required
@block_all_roles
def Projects(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    projects = Project.objects.all()
    
    # Pagination settings for the projects table
    project_paginator = Paginator(projects, 10)
    project_page = request.GET.get('project_page')
    paged_projects = project_paginator.get_page(project_page)
    
    # Fetching activities related to the projects
    activities = Activity.objects.filter(project__in=projects).distinct()
    activity_paginator = Paginator(activities, 10)
    activity_page = request.GET.get('activity_page')
    paged_activities = activity_paginator.get_page(activity_page)
    
    # Fetching core problems related to the projects
    solution_trees = SolutionTree.objects.filter(project__in=projects).distinct()  # Fetch all solution trees related to the Project
    core_problems = CoreProblem.objects.filter(solution_trees__in=solution_trees).distinct()  # Fetch all core problems related to those solution trees

    core_problem_paginator = Paginator(core_problems, 10)
    core_problem_page = request.GET.get('core_problem_page')
    paged_core_problems = core_problem_paginator.get_page(core_problem_page)

    # Fetching solution trees related to the paged core problems
    solution_trees = SolutionTree.objects.filter(core_problem__in=paged_core_problems).distinct()

    solution_tree_paginator = Paginator(solution_trees, 10)
    solution_tree_page = request.GET.get('solution_tree_page')
    paged_solution_trees = solution_tree_paginator.get_page(solution_tree_page)
    
    # Fetching results related to the projects
    results = Result.objects.filter(project__in=projects).distinct()
    result_paginator = Paginator(results, 10)
    result_page = request.GET.get('result_page')
    paged_results = result_paginator.get_page(result_page)
    
    # Fetching milestones related to the projects
    milestones = Milestone.objects.filter(project__in=projects).distinct()
    milestone_paginator = Paginator(milestones, 10)
    milestone_page = request.GET.get('milestone_page')
    paged_milestones = milestone_paginator.get_page(milestone_page)

    # Count entities
    project_count = projects.count()
    
    beneficiaries_count = Beneficiary.objects.count()
    stakeholders_count = Stakeholder.objects.count()
    activities_count = Activity.objects.count()
    context = {
        "webdata": webdata,
        "results": paged_results,
        "projects": paged_projects,
        "user_profile": user_profile,
        "project_count":project_count,
        "milestones": paged_milestones,
        "notifications": notifications,
        "activities": paged_activities,
        "activities_count":activities_count,
        "solution_trees": paged_solution_trees,
        "stakeholders_count":stakeholders_count,
        "beneficiaries_count":beneficiaries_count,
    }
    
    return render(request, 'backend/AdminProjectsPanel.html', context)



@user_authenticated
def users_account_page(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        user_profile.profile_picture = request.FILES.get('profile_picture', user_profile.profile_picture)
        user_profile.phone = request.POST.get('phone', user_profile.phone)
        user_profile.bio = request.POST.get('bio', user_profile.bio)
        
        try:
            user_profile.save()
            if 'resume_and_certifications' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('resume_and_certifications'):
                    resume_and_certifications = SupportDocument(file=document)
                    resume_and_certifications.save()
                    new_documents.append(resume_and_certifications)
                user_profile.resume_and_certifications.add(*new_documents)
            
            messages.success(request, 'Profile updated successfully.')
            
            email_subject = 'New User registered'
            email_body = render_to_string('backend/auth/Admin/Emails/User_profile_update_ADMIN_EMAIL.html', {
                'first_name': user_profile.user.first_name,
                'last_name': user_profile.user.last_name,
                'email': user_profile.user.email,
                'phone': user_profile.phone,
                'Organization': webdata.title,
                'profile_picture_url': user_profile.profile_picture.url if user_profile.profile_picture else static('assets/images/logo.svg'),
            })
            event_email = EmailMessage(
                email_subject,
                email_body,
                to=[settings.ADMIN_EMAIL],  
            )
            event_email.content_subtype = 'html'
            event_email.send()
            
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                user_profile.user,
                'Profile Update',
                f'User {user_profile.user.first_name}  {user_profile.user.last_name} ({user_profile.user.email}), Updated profile successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
        except Exception as e:
            messages.error(request, f'Error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                user_profile.user,
                'Profile Update failed',
                f'User {user_profile.user.first_name}  {user_profile.user.last_name} ({user_profile.user.email}), profile update failed at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
        return redirect('Dashboard') 

    context={
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }
    
    return render(request, 'backend/users/account.html', context)

@user_authenticated
def users_profile_page(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    context={
        "webdata":webdata,
        "user_profile":user_profile,
        "notifications": notifications,
        "user_profile": user_profile,
        "notifications": notifications,
    }
    return render(request, 'backend/users/profile.html', context)


@user_authenticated
@csrf_exempt
def mark_notification_as_read(request, notification_id):
    if request.method == 'POST':
        notification = get_object_or_404(AdminNotifications, pk=notification_id)

        notification_read, created = NotificationReadBy.objects.get_or_create(notification=notification, user=request.user)

        if created:
            notification_read.is_read = True
            notification_read.save()
        return JsonResponse({'message': 'Notification marked as read'}, status=200)
    else:
        return JsonResponse({'error': 'Method not allowed'}, status=405)


#################################################################################################################
#################################################################################################################
# ######################## CONTACT VIEW ###############################
#################################################################################################################
# #################################################################################################################

class ContactDeveloperCreateView(View):
    def get(self, request):
        return render(request, 'backend/auth/contact_developer.html')

    def post(self, request):
        subject = request.POST.get('Subject')
        message = request.POST.get('Textarea')

        if subject and message:
            # Assuming the user is logged in and we can retrieve their profile
            user_profile = UserProfile.objects.get(user=request.user)

            # Create the ContactDeveloper entry
            ContactDeveloper.objects.create(
                user=user_profile,
                subject=subject,
                message=message
            )

            # Send email to admin
            connection = get_connection()
            connection.open()

            # Prepare user information
            first_name = user_profile.user.first_name
            last_name = user_profile.user.last_name
            name = f"{first_name} {last_name}"
            email = user_profile.user.email
            phone = user_profile.phone

            # Email subject and body for admin
            email_subject_admin = 'New Developer Contact Form Submission'
            email_body_admin = render_to_string('backend/auth/Admin/Emails/contact_form_developer_email.html', {
                'name': name,
                'subject': subject,
                'email': email,
                'phone': phone,
                'message': message,
            })

            # Send email
            email_admin = EmailMessage(
                email_subject_admin,
                email_body_admin,
                to=[settings.ADMIN_EMAIL],
            )
            email_admin.content_subtype = 'html'
            email_admin.connection = connection
            email_admin.send()

            # Close connection
            connection.close()

            # Log activity (without user reference)
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')

            ActivityLog.objects.create(
                action='Contact Form Submission',
                details=f'{first_name} {last_name} submitted a contact form message at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
                status_code=200
            )

            messages.success(request, "Your message has been submitted successfully!")
            return redirect('Dashboard')

        else:
            messages.error(request, "Please fill out all fields.")
            return redirect('contact-developer')

@login_required
@block_all_roles
def submit_contact_form(request):
    try:
        if request.method == 'POST':
            name = request.POST.get('name')
            email = request.POST.get('email')
            phone = request.POST.get('phone')
            message = request.POST.get('message')

            # Save the message to the database
            contact_message = ContactAdminMessages.objects.create(
                name=name,
                email=email,
                phone=phone,
                message=message
            )
            contact_message.save()

            # Send email to admin
            connection = get_connection()
            connection.open()

            email_subject_admin = 'New Contact Form Submission'
            email_body_admin = render_to_string('backend/auth/Admin/Emails/contact_form_admin_email.html', {
                'name': name,
                'email': email,
                'phone': phone,
                'message': message,
            })

            email_admin = EmailMessage(
                email_subject_admin,
                email_body_admin,
                to=[settings.ADMIN_EMAIL],
            )
            email_admin.content_subtype = 'html'
            email_admin.connection = connection
            email_admin.send()

            # Close connection
            connection.close()

            # Log activity (without user reference)
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')

            ActivityLog.objects.create(
                action='Contact Form Submission',
                details=f'{name} ({email}) submitted a contact form message at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
                status_code=200
            )

            messages.success(request, 'Message sent successfully.')
            return redirect(reverse('contact_us') + '#contact_sec')

        else:
            messages.error(request, 'Unable to send message. Please check the form.')
            return redirect(reverse('contact_us') + '#contact_sec')

    except Exception as e:
        logging.error(f"Error during contact form submission: {str(e)}")
        
        # Log error activity (without user reference)
        ip_address = request.META.get('REMOTE_ADDR')
        user_agent = request.META.get('HTTP_USER_AGENT')

        ActivityLog.objects.create(
            action='Contact Form Submission Error',
            details=f"Error occurred: {str(e)}",
            ip_address=ip_address,
            user_agent=user_agent,
            status_code=500  # Assuming internal server error
        )

        messages.error(request, 'An error occurred while sending the message. Please try again later.')
        return redirect(reverse('contact_us') + '#contact_sec')



#PARTNER VIEWS
@login_required
@block_all_roles
def add_partnering_organization(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            name = request.POST.get('name')
            description = request.POST.get('description')
            type_id = request.POST.get('type')
            role_in_project = request.POST.get('role_in_project')
            strategic_importance = request.POST.get('strategic_importance')
            resource_and_contribution = request.POST.get('resource_and_contribution')
            website_link = request.POST.get('website_link')
            contact_person_name = request.POST.get('contact_person_name')
            contact_person_phone = request.POST.get('contact_person_phone')
            contact_person_email = request.POST.get('contact_person_email')

            type_instance = OrganizationType.objects.get(id=type_id) if type_id else None
    
            partnering_organization = PartneringOrganization(
                name=name,
                description=description,
                type=type_instance,
                role_in_project=role_in_project,
                strategic_importance=strategic_importance,
                resource_and_contribution=resource_and_contribution,
                website_link=website_link,
                contact_person_name=contact_person_name,
                contact_person_email=contact_person_email,
                contact_person_phone=contact_person_phone,
            )
            partnering_organization.save()
            if 'letter_of_support' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('letter_of_support'):
                    letter_of_support = SupportDocument(file=document)
                    letter_of_support.save()
                    new_documents.append(letter_of_support)
                partnering_organization.letter_of_support.add(*new_documents)
                
                
            if 'partnership_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('partnership_document'):
                    partnership_document = SupportDocument(file=document)
                    partnership_document.save()
                    new_documents.append(partnership_document)
                partnering_organization.partnership_document.add(*new_documents)
            
            if 'logo' in request.FILES:
                partnering_organization.logo = request.FILES['logo']
                partnering_organization.save()


            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add partnering organization success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added partnering organization {partnering_organization.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Partnering Organization added successfully.')
            return redirect('list_partnering_organizations')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add partnering organization failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding partnering organization at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_partnering_organization')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        "organization_types": OrganizationType.objects.all(),
    }

    return render(request, 'backend/project/partnering_organization/add_partnering_organization.html', context)

@login_required
@block_all_roles
def edit_partnering_organization(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    partnering_organization = get_object_or_404(PartneringOrganization, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            partnering_organization.name = request.POST.get('name')
            partnering_organization.description = request.POST.get('description')
            partnering_organization.type = OrganizationType.objects.get(id=request.POST.get('type'))
            partnering_organization.role_in_project = request.POST.get('role_in_project')
            partnering_organization.contact_person_name = request.POST.get('contact_person_name')
            partnering_organization.contact_person_phone = request.POST.get('contact_person_phone')
            partnering_organization.contact_person_email = request.POST.get('contact_person_email')
            partnering_organization.strategic_importance = request.POST.get('strategic_importance')
            partnering_organization.resource_and_contribution = request.POST.get('resource_and_contribution')
            partnering_organization.website_link = request.POST.get('website_link')
            partnering_organization.is_verified = request.POST.get('is_verified') == 'on'
            partnering_organization.save()

            if 'letter_of_support' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('letter_of_support'):
                    letter_of_support = SupportDocument(file=document)
                    letter_of_support.save()
                    new_documents.append(letter_of_support)
                partnering_organization.letter_of_support.add(*new_documents)
                
            if 'partnership_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('partnership_document'):
                    partnership_document = SupportDocument(file=document)
                    partnership_document.save()
                    new_documents.append(partnership_document)
                partnering_organization.partnership_document.add(*new_documents)
            
            if 'logo' in request.FILES:
                partnering_organization.logo = request.FILES['logo']
                partnering_organization.save()

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit partnering organization success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated partnering organization {partnering_organization.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Partnering Organization updated successfully.')
            return redirect('list_partnering_organizations')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit partnering organization failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating partnering organization at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )

    context = {
        "webdata": webdata,
        "partnering_organization": partnering_organization,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "projects": Project.objects.all(),
        "support_documents": SupportDocument.objects.all(),
        "organization_types": OrganizationType.objects.all(),
    }

    return render(request, 'backend/project/partnering_organization/edit_partnering_organization.html', context)


@login_required
@block_all_roles
def list_partnering_organizations(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    partnering_organizations_list = PartneringOrganization.objects.all()
    # Pagination
    paginator = Paginator(partnering_organizations_list, 10)
    page = request.GET.get('page')

    try:
        partnering_organizations_page = paginator.page(page)
    except PageNotAnInteger:
        partnering_organizations_page = paginator.page(1)
    except EmptyPage:
        partnering_organizations_page = paginator.page(paginator.num_pages)

    context = {
        "webdata": webdata,
        "partners": partnering_organizations_page,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/project/partnering_organization/list_partnering_organizations.html', context)

@login_required
@block_all_roles
def delete_partnering_organization(request, slug):
    partnering_organization = get_object_or_404(PartneringOrganization, slug=slug)

    if request.method == 'POST':
        try:
            partnering_organization.delete()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete partnering organization success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted partnering organization {partnering_organization.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Partnering Organization deleted successfully.')
            return redirect('list_partnering_organizations')
        except Exception as e:
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete partnering organization failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting partnering organization at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.error(request, f'An error occurred: {str(e)}')

    return redirect('list_partnering_organizations')
@login_required
@is_partner
def download_partnering_organizations(request):
    # Query all partnering organizations
    partnering_organizations = PartneringOrganization.objects.all()

    # Create the HTTP response with appropriate headers for CSV download
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = 'attachment; filename="partnering_organizations.csv"'

    # Create a CSV writer object
    writer = csv.writer(response)
    
    # Write the header row
    writer.writerow([
        'Name',
        'Description',
        'Type',
        'Website Link',
        'Role in Project',
        'Strategic Importance',
        'Resource and Contribution'
    ])

    # Write data rows
    for org in partnering_organizations:
        writer.writerow([
            org.name,
            org.description,
            org.type,  
            org.website_link,
            org.role_in_project,
            org.strategic_importance,
            org.resource_and_contribution
        ])

    return response

def add_edit_partner_feedback_support(request, feedback_support_id=None):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    partnering_organizations = PartneringOrganization.objects.all()

    # If `feedback_support_id` is provided, we're editing an existing record; otherwise, we're adding a new one
    if feedback_support_id:
        feedback_support = get_object_or_404(PartnerOrganizationFeedbackAndSupport, id=feedback_support_id)
    else:
        feedback_support = None

    if request.method == 'POST':
        partnering_org_id = request.POST.get('partnering_organization')
        feedback = request.POST.get('feedback')
        support = request.POST.get('support')

        # Validating required fields
        if not partnering_org_id:
            messages.error(request, 'Partnering organization is required.')
            return redirect('add_partner_feedback_support')

        partnering_organization = PartneringOrganization.objects.filter(id=partnering_org_id).first()
        if not partnering_organization:
            messages.error(request, 'Invalid partnering organization selected.')
            return redirect('add_partner_feedback_support')

        # If editing, update the existing instance
        if feedback_support:
            feedback_support.partnering_organization = partnering_organization
            feedback_support.feedback = feedback
            feedback_support.support = support
        else:
            # Create a new instance
            feedback_support = PartnerOrganizationFeedbackAndSupport(
                partnering_organization=partnering_organization,
                feedback=feedback,
                support=support
            )

        # Save the instance
        try:
            feedback_support.save()
            action = "updated" if feedback_support_id else "added"
            messages.success(request, f'Partner feedback and support {action} successfully.')
            return redirect('Dashboard')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect('add_partner_feedback_support')

    context = {
        "webdata": webdata,
        "notifications": notifications,
        "partnering_organizations": partnering_organizations,
        "feedback_support": feedback_support,
    }
    return render(request, 'backend/project/partnering_organization/add_edit_partner_feedback_support.html', context)
#################################################################################################################
#################################################################################################################
# ######################## Project VIEWS (ADD, EDIT, DELETE..ETC ) #####################################
#################################################################################################################
#################################################################################################################

#project views
@login_required
@block_all_roles
def add_project(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            title = request.POST.get('title')
            description = request.POST.get('description')
            category = request.POST.get('category')
            status = request.POST.get('status')
            project_cycle = request.POST.get('project_cycle')
            project_phase = request.POST.get('project_phase')
            stakeholders_ids = request.POST.getlist('stakeholders') 
            beneficiaries_ids = request.POST.getlist('beneficiaries') 
            partners_ids = request.POST.getlist('partners') 
            solution_trees_ids = request.POST.getlist('solution_trees')
            activities_ids = request.POST.getlist('activities')
            
            donation_needed = request.POST.get('donation_needed') or 0
            donation_raised = request.POST.get('donation_raised') or 0
            problem_statement = request.POST.get('problem_statement') or None
            problem_impact = request.POST.get('problem_impact') or None
            project_goals = request.POST.get('project_goals') or None


            project = Project(
                author=user_profile,
                title=title,
                description=description,
                category=category,
                status=status,
                project_cycle=project_cycle,
                project_phase=project_phase,
                donation_needed=donation_needed,
                donation_raised=donation_raised,
                problem_statement=problem_statement,
                problem_impact=problem_impact,
                project_goals=project_goals,
            )
            project.save()
            
            valid_stakeholders = Stakeholder.objects.filter(id__in=stakeholders_ids)
            valid_beneficiaries = Beneficiary.objects.filter(id__in=beneficiaries_ids)
            valid_partners = PartneringOrganization.objects.filter(id__in=partners_ids)
            valid_activities = Activity.objects.filter(id__in=activities_ids)
            valid_solution_trees = SolutionTree.objects.filter(id__in=solution_trees_ids)

            project.stakeholders.set(valid_stakeholders)  
            project.beneficiaries.set(valid_beneficiaries)
            project.partners.set(valid_partners)
            project.activities.set(valid_activities) 
            project.solution_trees.set(valid_solution_trees) 

            

            if 'project_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('project_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                project.project_document.add(*new_documents)
                
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add project success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added project --{project.title}-- successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'project added successfully.')
            return redirect('list_projects')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add project failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding project at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_project')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        "activities": Activity.objects.all(),
        "stakeholders": Stakeholder.objects.all(),
        "beneficiaries": Beneficiary.objects.all(),
        "solution_trees": SolutionTree.objects.all(),
        "partners": PartneringOrganization.objects.all(),
        
        "status_choices": Project.STATUS_CHOICES,
        "Category_choices":Project.CATEGORY_CHOICES,
        "project_cycle_choices": Project.PROJECT_CYCLE_CHOICES,
        "project_phase_choices": Project.PROJECT_PHASE_CHOICES,
    }

    return render(request, 'backend/project/add_project.html', context)

@login_required
@block_all_roles
def list_projects(request):
    projects = Project.objects.all()
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    # Pagination
    paginator = Paginator(projects, 10)
    page = request.GET.get('page')

    try:
        projects_page = paginator.page(page)
    except PageNotAnInteger:
        projects_page = paginator.page(1)
    except EmptyPage:
        projects_page = paginator.page(paginator.num_pages)

    context = {
        "webdata":webdata,
        "projects": projects_page,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/list_projects.html', context)

@login_required
@block_all_roles
def edit_project(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    project = get_object_or_404(Project, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            project.title = request.POST.get('title')
            project.description = request.POST.get('description')
            project.category = request.POST.get('category')
            
            project.status = request.POST.get('status')
            project.project_cycle = request.POST.get('project_cycle')
            project.project_phase = request.POST.get('project_phase')
            project.donation_needed = request.POST.get('donation_needed') or 0
            project.donation_raised = request.POST.get('donation_raised') or 0
            project.problem_statement = request.POST.get('problem_statement') or None
            project.problem_impact = request.POST.get('problem_impact') or None
            project.project_goals = request.POST.get('project_goals') or None

            project.save()
            project.stakeholders.set(request.POST.getlist('stakeholders'))
            project.beneficiaries.set(request.POST.getlist('beneficiaries'))
            project.partners.set(request.POST.getlist('partners'))
            project.activities.set(request.POST.getlist('activities'))
            project.solution_trees.set(request.POST.getlist('solution_trees'))

            

            if 'project_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('project_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                project.project_document.add(*new_documents)

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit project success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated project {project.title} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'project updated successfully.')
            return redirect('list_projects')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit project failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating project at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('edit_project', slug=project.slug)

    # Prepare data for template
    context = {
        "project": project,
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "activities": Activity.objects.all(),
        "stakeholders": Stakeholder.objects.all(),
        "beneficiaries": Beneficiary.objects.all(),
        "partners": PartneringOrganization.objects.all(),
        "solution_trees": SolutionTree.objects.all(),
        
        "project_activities_ids": project.activities.values_list('id', flat=True),
        "project_stakeholders_ids": project.stakeholders.values_list('id', flat=True),
        "project_beneficiaries_ids": project.beneficiaries.values_list('id', flat=True),
        "project_partners_ids": project.partners.values_list('id', flat=True),
        "project_solution_trees_ids": project.solution_trees.values_list('id', flat=True),
    }

    return render(request, 'backend/project/edit_project.html', context)


@login_required
@block_all_roles
def delete_project(request, slug):
    project = get_object_or_404(Project, slug=slug)

    if request.method == 'POST':
        try:
            project.delete()

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete project success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted project {project.title} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'project deleted successfully.')
            return redirect('list_projects')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete project failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting project at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('view_project', slug=slug)
    return redirect('list_projects')



# INDICATOR views
@login_required
@block_all_roles
def add_indicator(request):
    user = request.user
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            name = request.POST.get('name')
            notes = request.POST.get('notes')
            description = request.POST.get('description')
            measure_type = request.POST.get('measure_type')
            measure_unit = request.POST.get('measure_unit')
            data_source = request.POST.get('data_source')
            baseline = request.POST.get('baseline')
            achieved_value = request.POST.get('achieved_value')
            target = request.POST.get('target')
            relevance = request.POST.get('relevance')

            # Handle checkboxes
            economic = 'economic' in request.POST
            is_target_achieved = 'is_target_achieved' in request.POST
            monitorable = 'monitorable' in request.POST

            adequacy = request.POST.get('adequacy')

            # Create the Indicator instance
            indicator = Indicator(
                name=name,
                description=description,
                notes=notes,
                measure_type=measure_type,
                measure_unit=measure_unit,
                data_source=data_source,
                relevance=relevance,
                economic=economic,
                adequacy=adequacy,
                monitorable=monitorable,
                is_target_achieved=is_target_achieved,
            )

            # Set baseline and target only if values are provided
            if baseline:
                indicator.baseline = baseline
            if target:
                indicator.target = target
            if achieved_value:
                indicator.achieved_value = achieved_value

            indicator.save()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add indicator success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added indicator {indicator.name} successfully {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Indicator added successfully.')
            return redirect('list_indicators')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add indicator failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered the error {str(e)} when adding indicator at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_indicator')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        "measure_type_choices": Indicator.MEASURE_TYPE_CHOICES,
        "measure_unit_choices": Indicator.MEASURE_UNIT_CHOICES,
        "data_source_choices": Indicator.DATA_SOURCE_CHOICES,
    }

    return render(request, 'backend/project/indicator/add_indicator.html', context)


@login_required
@block_all_roles
def list_indicators(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    indicators_list = Indicator.objects.all()
    # Pagination
    paginator = Paginator(indicators_list, 10)
    page = request.GET.get('page')

    try:
        indicators_page = paginator.page(page)
    except PageNotAnInteger:
        indicators_page = paginator.page(1)
    except EmptyPage:
        indicators_page = paginator.page(paginator.num_pages)
    
    context = {
        "webdata":webdata,
        "indicators": indicators_page,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/indicator/list_indicators.html', context)

@login_required
@block_all_roles
def edit_indicator(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    indicator = get_object_or_404(Indicator, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            indicator.name = request.POST.get('name')
            indicator.description = request.POST.get('description')
            indicator.notes = request.POST.get('notes')
            indicator.measure_type = request.POST.get('measure_type')
            indicator.measure_unit = request.POST.get('measure_unit')
            indicator.data_source = request.POST.get('data_source')
            indicator.baseline = request.POST.get('baseline')
            indicator.target = request.POST.get('target')
            indicator.achieved_value = request.POST.get('achieved_value')
            indicator.relevance = request.POST.get('relevance')
            indicator.is_target_achieved = request.POST.get('is_target_achieved') == 'on'
            indicator.economic = request.POST.get('economic') == 'on'
            indicator.adequacy = request.POST.get('adequacy')
            indicator.monitorable = request.POST.get('monitorable') == 'on'
            indicator.save()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit indicator success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated indicator {indicator.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Indicator updated successfully.')
            return redirect('list_indicators')
        except Exception as e:
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit indicator failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating indicator at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.error(request, f'An error occurred: {str(e)}')

    context = {
        "webdata":webdata,
        'indicator': indicator,
        "user_profile": user_profile,
        "notifications": notifications,
        'measure_type_choices': Indicator.MEASURE_TYPE_CHOICES,
        'measure_unit_choices': Indicator.MEASURE_UNIT_CHOICES,
        "data_source_choices": Indicator.DATA_SOURCE_CHOICES,
        
    }
    return render(request, 'backend/project/indicator/edit_indicator.html', context)

@login_required
@block_all_roles
def delete_indicator(request, slug):
    indicator = get_object_or_404(Indicator, slug=slug)

    if request.method == 'POST':
        try:
            indicator.delete()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete indicator success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted indicator {indicator.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Indicator deleted successfully.')
            return redirect('list_indicators')
        except Exception as e:
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete indicator failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting indicator at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.error(request, f'An error occurred: {str(e)}')

    return redirect('list_indicators')


# BENEFICIARIES VIEWS
@login_required
@block_all_roles
def add_beneficiary(request):
    user = request.user
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            name = request.POST.get('name')
            location = request.POST.get('location')
            description = request.POST.get('description')
            category = request.POST.get('category')
            priority = request.POST.get('priority')
            strength = request.POST.get('strength')
            weakness = request.POST.get('weakness')
            opportunities = request.POST.get('opportunities')
            threats = request.POST.get('threats')
            needs = request.POST.get('needs')
            when_to_engage = request.POST.get('when_to_engage')
            how_to_engage = request.POST.get('how_to_engage')
            engagement_channels = request.POST.get('engagement_channels')
            engagement_frequency = request.POST.get('engagement_frequency')
            support_documents = request.FILES.getlist('support_document')

            beneficiary = Beneficiary(
                name=name,
                location=location,
                description=description,
                category=category,
                priority=priority,
                strength=strength,
                weakness=weakness,
                opportunities=opportunities,
                threats=threats,
                needs=needs,
                when_to_engage=when_to_engage,
                how_to_engage=how_to_engage,
                engagement_channels=engagement_channels,
                engagement_frequency=engagement_frequency
            )
            beneficiary.save()
            for document in support_documents:
                support_document = SupportDocument(file=document)
                support_document.save()
                beneficiary.support_document.add(support_document)
            
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add beneficiary success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added beneficiary {beneficiary.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Beneficiary added successfully.')
            return redirect('list_beneficiaries')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add beneficiary failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding beneficiary at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_beneficiary')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        "category_choices": Beneficiary.CATEGORY_CHOICES,
        "priority_choices": Beneficiary.PRIORITY_CHOICES
    }

    return render(request, 'backend/project/beneficiary/add_beneficiary.html', context)

@login_required
@block_all_roles
def list_beneficiaries(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    beneficiaries_list = Beneficiary.objects.all().order_by('-created_at')
    # Pagination
    paginator = Paginator(beneficiaries_list, 10)
    page = request.GET.get('page')

    try:
        beneficiaries_page = paginator.page(page)
    except PageNotAnInteger:
        beneficiaries_page = paginator.page(1)
    except EmptyPage:
        beneficiaries_page = paginator.page(paginator.num_pages)
    
    
    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        "beneficiaries": beneficiaries_page,
        
    }

    return render(request, 'backend/project/beneficiary/list_beneficiaries.html', context)

@login_required
@block_all_roles
def edit_beneficiary(request, slug):
    user_profile = request.user.userprofile
    webdata = WebData.objects.first()
    beneficiary = get_object_or_404(Beneficiary, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        try:
            beneficiary.name = request.POST.get('name')
            beneficiary.location = request.POST.get('location')
            beneficiary.description = request.POST.get('description')
            beneficiary.category = request.POST.get('category')
            beneficiary.priority = request.POST.get('priority')
            beneficiary.strength = request.POST.get('strength')
            beneficiary.weakness = request.POST.get('weakness')
            beneficiary.opportunities = request.POST.get('opportunities')
            beneficiary.threats = request.POST.get('threats')
            beneficiary.needs = request.POST.get('needs')
            beneficiary.when_to_engage = request.POST.get('when_to_engage')
            beneficiary.how_to_engage = request.POST.get('how_to_engage')
            beneficiary.engagement_channels = request.POST.get('engagement_channels')
            beneficiary.engagement_frequency = request.POST.get('engagement_frequency')
            
            beneficiary.save()
            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                beneficiary.support_document.add(*new_documents)
            
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit beneficiary success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated beneficiary {beneficiary.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Beneficiary updated successfully.')
            return redirect('list_beneficiaries')
        except Exception as e:
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit beneficiary failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating beneficiary at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.error(request, f'An error occurred: {str(e)}')

    context = {
        "webdata":webdata,
        'beneficiary': beneficiary,
        "user_profile": user_profile,
        "notifications": notifications,
        'category_choices': Beneficiary.CATEGORY_CHOICES,
        'priority_choices': Beneficiary.PRIORITY_CHOICES
    }
    return render(request, 'backend/project/beneficiary/edit_beneficiary.html', context)

@login_required
@block_all_roles
def delete_beneficiary(request, slug):
    beneficiary = get_object_or_404(Beneficiary, slug=slug)

    if request.method == 'POST':
        try:
            beneficiary.delete()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete beneficiary success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted beneficiary {beneficiary.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Beneficiary deleted successfully.')
            return redirect('list_beneficiaries')
        except Exception as e:
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete beneficiary failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting beneficiary at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.error(request, f'An error occurred: {str(e)}')

    return redirect('list_beneficiaries')


# STAKEHOLDER VIEWS
@login_required
@block_all_roles
def add_stakeholder(request):
    user = request.user
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    partnering_organizations = PartneringOrganization.objects.all()
    if request.method == 'POST':
        try:
            orgnanization = request.POST.get('orgnanization')
            name = request.POST.get('name')
            location = request.POST.get('location')
            description = request.POST.get('description')
            strength = request.POST.get('strength')
            contribution = request.POST.get('contribution')
            expectations = request.POST.get('expectations')
            interests = request.POST.get('interests')
            affect_project = request.POST.get('affect_project')
            affected_by_project = request.POST.get('affected_by_project')
            affect_project_results = request.POST.get('affect_project_results')
            affected_by_project_results = request.POST.get('affected_by_project_results')
            gain_from_project = request.POST.get('gain_from_project')
            support_documents = request.FILES.getlist('support_document')

            stakeholder = Stakeholder(
                orgnanization_id=orgnanization if orgnanization else None,
                name=name,
                location=location,
                description=description,
                strength=strength,
                contribution=contribution,
                expectations=expectations,
                interests=interests,
                affect_project=affect_project,
                affected_by_project=affected_by_project,
                affect_project_results=affect_project_results,
                affected_by_project_results=affected_by_project_results,
                gain_from_project=gain_from_project
            )
            stakeholder.save()
            
            for document in support_documents:
                support_document = SupportDocument(file=document)
                support_document.save()
                stakeholder.support_document.add(support_document)
            
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add stakeholder success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added stakeholder {stakeholder.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Stakeholder added successfully.')
            return redirect('list_stakeholders')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add stakeholder failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding stakeholder at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_stakeholder')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        "partnering_organizations": partnering_organizations,
        "affect_project_choices": Stakeholder.AFFECT_PROJECT_CHOICES,
        "affected_by_project_choices": Stakeholder.AFFECTED_BY_PROJECT_CHOICES,
        "affect_project_results_choices": Stakeholder.AFFECT_PROJECT_RESULTS_CHOICES,
        "affected_by_project_results_choices": Stakeholder.AFFECTED_BY_PROJECT_RESULTS_CHOICES
    }

    return render(request, 'backend/project/stakeholder/add_stakeholder.html', context)

@login_required
@block_all_roles
def list_stakeholders(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    stakeholders = Stakeholder.objects.all().order_by('-created_at')
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    # Pagination
    paginator = Paginator(stakeholders, 10)
    page = request.GET.get('page')

    try:
        stakeholders_page = paginator.page(page)
    except PageNotAnInteger:
        stakeholders_page = paginator.page(1)
    except EmptyPage:
        stakeholders_page = paginator.page(paginator.num_pages)

    context = {
        "webdata":webdata,
        "stakeholders": stakeholders_page,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/stakeholder/list_stakeholders.html', context)

@login_required
@block_all_roles
def edit_stakeholder(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    stakeholder = get_object_or_404(Stakeholder, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    partnering_organizations = PartneringOrganization.objects.all()
    
    if request.method == 'POST':
        try:
            stakeholder.orgnanization_id = request.POST.get('orgnanization') if request.POST.get('orgnanization') else None
            stakeholder.name = request.POST.get('name')
            stakeholder.location = request.POST.get('location')
            stakeholder.description = request.POST.get('description')
            stakeholder.strength = request.POST.get('strength')
            stakeholder.contribution = request.POST.get('contribution')
            stakeholder.expectations = request.POST.get('expectations')
            stakeholder.interests = request.POST.get('interests')
            stakeholder.affect_project = request.POST.get('affect_project')
            stakeholder.affected_by_project = request.POST.get('affected_by_project')
            stakeholder.affect_project_results = request.POST.get('affect_project_results')
            stakeholder.affected_by_project_results = request.POST.get('affected_by_project_results')
            stakeholder.gain_from_project = request.POST.get('gain_from_project')
            stakeholder.save()
            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                stakeholder.support_document.add(*new_documents)
            
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit stakeholder success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated stakeholder {stakeholder.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Stakeholder updated successfully.')
            return redirect('list_stakeholders')
        except Exception as e:
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit stakeholder failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating stakeholder at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.error(request, f'An error occurred: {str(e)}')

    context = {
        "webdata":webdata,
        'stakeholder': stakeholder,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "partnering_organizations": partnering_organizations,
        'affect_project_choices': Stakeholder.AFFECT_PROJECT_CHOICES,
        'affected_by_project_choices': Stakeholder.AFFECTED_BY_PROJECT_CHOICES,
        'affect_project_results_choices': Stakeholder.AFFECT_PROJECT_RESULTS_CHOICES,
        'affected_by_project_results_choices': Stakeholder.AFFECTED_BY_PROJECT_RESULTS_CHOICES
    }
    return render(request, 'backend/project/stakeholder/edit_stakeholder.html', context)


@login_required
@block_all_roles
def delete_stakeholder(request, slug):
    stakeholder = get_object_or_404(Stakeholder, slug=slug)

    if request.method == 'POST':
        try:
            stakeholder.delete()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete stakeholder success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted stakeholder {stakeholder.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Stakeholder deleted successfully.')
            return redirect('list_stakeholders')
        except Exception as e:
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete stakeholder failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting stakeholder at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.error(request, f'An error occurred: {str(e)}')

    return redirect('list_stakeholders')


# RESOURCES VIEWS
@login_required
@block_all_roles
def add_resource(request):
    user = request.user
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            name = request.POST.get('name')
            number = int(request.POST.get('number', 0))  # Convert to integer
            unit_cost = float(request.POST.get('unit_cost', 0.0))  # Convert to float
            use_function = request.POST.get('use_function')

            resource = Resource(
                name=name,
                number=number,
                unit_cost=unit_cost,
                use_function=use_function
            )
            resource.save()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add resource success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added resource {resource.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Resource added successfully.')
            return redirect('list_resources')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add resource failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding resource at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_resource')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/resource/add_resource.html', context)

@login_required
@block_all_roles
def list_resources(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    resources_list = Resource.objects.all()
    # Pagination
    paginator = Paginator(resources_list, 10)
    page = request.GET.get('page')

    try:
        resources_page = paginator.page(page)
    except PageNotAnInteger:
        resources_page = paginator.page(1)
    except EmptyPage:
        resources_page = paginator.page(paginator.num_pages)

    context = {
        "webdata":webdata,
        "resources": resources_page,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/resource/list_resources.html', context)

@login_required
@block_all_roles
def edit_resource(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    resource = get_object_or_404(Resource, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            resource.name = request.POST.get('name')
            resource.number = int(request.POST.get('number', 0))  # Convert to integer
            resource.unit_cost = float(request.POST.get('unit_cost', 0.0))  # Convert to float
            resource.use_function = request.POST.get('use_function')
            resource.save()

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit resource success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated resource {resource.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Resource updated successfully.')
            return redirect('list_resources')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit resource failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating resource at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('edit_resource', slug=resource.slug)

    context = {
        "webdata":webdata,
        'resource': resource,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }
    return render(request, 'backend/project/resource/edit_resource.html', context)

@login_required
@block_all_roles
def delete_resource(request, slug):
    resource = get_object_or_404(Resource, slug=slug)

    if request.method == 'POST':
        try:
            resource.delete()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete resource success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted resource {resource.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Resource deleted successfully.')
            return redirect('list_resources')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete resource failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting resource at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('list_resources')

    return redirect('list_resources')



#ACTIVITY VIEWS
@login_required
@block_all_roles
def add_activity(request):
    user = request.user
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    status_choices = Activity.STATUS_CHOICES
    
    users = User.objects.filter(Q(is_staff=True) | Q(is_superuser=True)).distinct()


    if request.method == 'POST':
        try:
            name = request.POST.get('name')
            resources = request.POST.getlist('resources')
            stakeholders = request.POST.getlist('stakeholders')
            beneficiaries = request.POST.getlist('beneficiaries')
            status = request.POST.get('status')
            start_date = request.POST.get('start_date')
            end_date = request.POST.get('end_date')
            goals_and_objectives = request.POST.get('goals_and_objectives')
            user_responsible = request.POST.get('user_responsible')
            inputs_needed = request.POST.get('inputs_needed')
            outputs_needed_to_achieve_outcomes = request.POST.get('outputs_needed_to_achieve_outcomes')
            outcomes_to_be_achieved = request.POST.get('outcomes_to_be_achieved')
            impact = request.POST.get('impact')
            strategy = request.POST.get('strategy')
            how_activity_will_be_carried_out = request.POST.get('how_activity_will_be_carried_out')
            cost = request.POST.get('cost')
            support_document = request.FILES.getlist('support_document')

            activity = Activity(
                name=name,
                status=status,
                start_date=start_date,
                end_date=end_date,
                goals_and_objectives=goals_and_objectives,
                user_responsible_id=user_responsible,
                inputs_needed=inputs_needed,
                outputs_needed_to_achieve_outcomes=outputs_needed_to_achieve_outcomes,
                outcomes_to_be_achieved=outcomes_to_be_achieved,
                impact=impact,
                strategy=strategy,
                how_activity_will_be_carried_out=how_activity_will_be_carried_out,
                cost=cost
            )
            activity.save()
            activity.resources.set(resources)
            activity.stakeholders.set(stakeholders)
            activity.beneficiaries.set(beneficiaries)
            
            for doc in support_document:
                support_doc = SupportDocument(file=doc)
                support_doc.save()
                activity.support_document.add(support_doc)
            
            if user_responsible:
                user_responsible_profile = UserProfile.objects.get(id=user_responsible)
                email_subject = f"Responsibility for Activity: {activity.name}"
                email_body = render_to_string('backend/project/activity/emails/activity_responsibility_email.html', {
                    'first_name': user_responsible_profile.user.first_name,
                    'last_name': user_responsible_profile.user.last_name,
                    'activity_name': activity.name,
                    'start_date': activity.start_date,
                    'end_date': activity.end_date,
                    'inputs_needed': activity.inputs_needed,
                    'outputs_needed_to_achieve_outcomes': activity.outputs_needed_to_achieve_outcomes,
                    'outcomes_to_be_achieved': activity.outcomes_to_be_achieved,
                    'impact': activity.impact,
                    'strategy': activity.strategy,
                    'how_activity_will_be_carried_out': activity.how_activity_will_be_carried_out,
                    'cost': activity.cost,
                    'goals_and_objectives': activity.goals_and_objectives,
                    'Organization': webdata.title,
                })
                event_email = EmailMessage(
                    email_subject,
                    email_body,
                    to=[user_responsible_profile.user.email],
                )
                event_email.content_subtype = 'html'
                event_email.send()

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add activity success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added activity {activity.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Activity added successfully.')
            return redirect('list_activities')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add activity failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding activity at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_activity')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "resources": Resource.objects.all(),
        "stakeholders": Stakeholder.objects.all(),
        "beneficiaries": Beneficiary.objects.all(),
        "support_documents": SupportDocument.objects.all(),
        "status_choices": status_choices,
        "users": users,
    }

    return render(request, 'backend/project/activity/add_activity.html', context)

@login_required
@block_all_roles
def list_activities(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    activities = Activity.objects.all().order_by('-start_date')
    # Pagination
    paginator = Paginator(activities, 10)
    page = request.GET.get('page')

    try:
        activities_page = paginator.page(page)
    except PageNotAnInteger:
        activities_page = paginator.page(1)
    except EmptyPage:
        activities_page = paginator.page(paginator.num_pages)

    context = {
        "webdata":webdata,
        "activities": activities_page,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/activity/list_activities.html', context)

@login_required
@block_all_roles
def edit_activity(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    activity = get_object_or_404(Activity, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    users = User.objects.filter(Q(is_staff=True) | Q(is_superuser=True)).distinct()
    status_choices = Activity.STATUS_CHOICES

    if request.method == 'POST':
        try:
            previous_user_responsible = activity.user_responsible
            activity.name = request.POST.get('name')
            activity.status = request.POST.get('status')
            activity.start_date = request.POST.get('start_date')
            activity.end_date = request.POST.get('end_date')
            activity.goals_and_objectives = request.POST.get('goals_and_objectives')
            activity.user_responsible_id = request.POST.get('user_responsible')
            activity.inputs_needed = request.POST.get('inputs_needed')
            activity.outputs_needed_to_achieve_outcomes = request.POST.get('outputs_needed_to_achieve_outcomes')
            activity.outcomes_to_be_achieved = request.POST.get('outcomes_to_be_achieved')
            activity.impact = request.POST.get('impact')
            activity.strategy = request.POST.get('strategy')
            activity.how_activity_will_be_carried_out = request.POST.get('how_activity_will_be_carried_out')
            activity.cost = request.POST.get('cost')
            activity.save()

            activity.resources.set(request.POST.getlist('resources'))
            activity.stakeholders.set(request.POST.getlist('stakeholders'))
            activity.beneficiaries.set(request.POST.getlist('beneficiaries'))
            
            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                activity.support_document.add(*new_documents)
                
            # Send email to the user responsible if changed or same
            if activity.user_responsible != previous_user_responsible or activity.user_responsible:
                user_responsible_profile = UserProfile.objects.get(id=activity.user_responsible_id)
                email_subject = f"Updated Responsibility for Activity: {activity.name}"
                email_body = render_to_string('backend/project/activity/emails/activity_responsibility_email.html', {
                    'first_name': user_responsible_profile.user.first_name,
                    'last_name': user_responsible_profile.user.last_name,
                    'activity_name': activity.name,
                    'start_date': activity.start_date,
                    'end_date': activity.end_date,
                    'inputs_needed': activity.inputs_needed,
                    'outputs_needed_to_achieve_outcomes': activity.outputs_needed_to_achieve_outcomes,
                    'outcomes_to_be_achieved': activity.outcomes_to_be_achieved,
                    'impact': activity.impact,
                    'strategy': activity.strategy,
                    'how_activity_will_be_carried_out': activity.how_activity_will_be_carried_out,
                    'cost': activity.cost,
                    'goals_and_objectives': activity.goals_and_objectives,
                    'Organization': webdata.title,
                })
                event_email = EmailMessage(
                    email_subject,
                    email_body,
                    to=[user_responsible_profile.user.email],
                )
                event_email.content_subtype = 'html'
                event_email.send()
            
            
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit activity success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated activity {activity.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Activity updated successfully.')
            return redirect('list_activities')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit activity failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating activity at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('edit_activity', slug=activity.slug)

    context = {
        "users": users,
        "webdata":webdata,
        'activity': activity,
        "user_profile": user_profile,
        "notifications": notifications,
        "status_choices":status_choices,
        
        
        "resources": Resource.objects.all(),
        "stakeholders": Stakeholder.objects.all(),
        "beneficiaries": Beneficiary.objects.all(),
        "support_documents": SupportDocument.objects.all(),
    }
    return render(request, 'backend/project/activity/edit_activity.html', context)

@login_required
@block_all_roles
def delete_activity(request, slug):
    activity = get_object_or_404(Activity, slug=slug)

    if request.method == 'POST':
        try:
            activity.delete()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete activity success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted activity {activity.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Activity deleted successfully.')
            return redirect('list_activities')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete activity failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting activity at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('list_activities')

    return redirect('list_activities')



# CORE PROBLEM VIEWS
@login_required
@block_all_roles
def add_core_problem(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    
    if request.method == 'POST':
        try:
            name = request.POST.get('name')
            description = request.POST.get('description')
            driver = request.POST.get('driver')
            root_causes = request.POST.get('root_causes')
            effects = request.POST.get('effects')
            impact = request.POST.get('impact')
            assumption = request.POST.get('assumption')
            opportunity = request.POST.get('opportunity')
            constraints = request.POST.get('constraints')

            core_problem = CoreProblem(
                name=name,
                description=description,
                driver=driver,
                root_causes=root_causes,
                effects=effects,
                impact=impact,
                assumption=assumption,
                opportunity=opportunity,
                constraints=constraints
            )
            core_problem.save()
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                core_problem.support_document.add(*new_documents)

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add core problem success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added core problem {core_problem.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Core problem added successfully.')
            return redirect('list_core_problems')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add core problem failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding core problem at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_core_problem')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "support_documents": SupportDocument.objects.all(),
    }

    return render(request, 'backend/project/core_problem/add_core_problem.html', context)

@login_required
@block_all_roles
def list_core_problems(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    core_problems_list = CoreProblem.objects.all().order_by('-created_at')
    # Pagination
    paginator = Paginator(core_problems_list, 10)
    page = request.GET.get('page')

    try:
        core_problems_page = paginator.page(page)
    except PageNotAnInteger:
        core_problems_page = paginator.page(1)
    except EmptyPage:
        core_problems_page = paginator.page(paginator.num_pages)

    context = {
        "webdata":webdata,
        "core_problems": core_problems_page,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/core_problem/list_core_problems.html', context)

@login_required
@block_all_roles
def edit_core_problem(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    core_problem = get_object_or_404(CoreProblem, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            core_problem.name = request.POST.get('name')
            core_problem.description = request.POST.get('description')
            core_problem.driver = request.POST.get('driver')
            core_problem.root_causes = request.POST.get('root_causes')
            core_problem.effects = request.POST.get('effects')
            core_problem.impact = request.POST.get('impact')
            core_problem.assumption = request.POST.get('assumption')
            core_problem.opportunity = request.POST.get('opportunity')
            core_problem.constraints = request.POST.get('constraints')
            core_problem.save()

            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                core_problem.support_document.add(*new_documents)
                
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit core problem success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated core problem {core_problem.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Core problem updated successfully.')
            return redirect('list_core_problems')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit core problem failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating core problem at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('edit_core_problem', slug=core_problem.slug)

    context = {
        "webdata":webdata,
        'core_problem': core_problem,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "support_documents": SupportDocument.objects.all(),
    }
    return render(request, 'backend/project/core_problem/edit_core_problem.html', context)

@login_required
@block_all_roles
def delete_core_problem(request, slug):
    core_problem = get_object_or_404(CoreProblem, slug=slug)

    if request.method == 'POST':
        try:
            core_problem.delete()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete core problem success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted core problem {core_problem.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Core problem deleted successfully.')
            return redirect('list_core_problems')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete core problem failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting core problem at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('list_core_problems')

    return redirect('list_core_problems')


# SOLUTION TREE
@login_required
@block_all_roles
def add_solution_tree(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    users = User.objects.filter(Q(is_staff=True) | Q(is_superuser=True)).distinct()

    if request.method == 'POST':
        try:
            core_problem = get_object_or_404(CoreProblem, id=request.POST.get('core_problem'))
            identified_solution = request.POST.get('identified_solution')
            solution_drivers = request.POST.get('solution_drivers')
            strategy = request.POST.get('strategy')
            inputs = request.POST.get('inputs')
            outputs = request.POST.get('outputs')
            outcomes = request.POST.get('outcomes')
            impact = request.POST.get('impact')
            expected_results = request.POST.get('expected_results')
            sustainability_plan = request.POST.get('sustainability_plan')
            stakeholders = request.POST.getlist('stakeholders')
            beneficiaries = request.POST.getlist('beneficiaries')
            user_responsible = get_object_or_404(UserProfile, id=request.POST.get('user_responsible'))

            solution_tree = SolutionTree(
                core_problem=core_problem,
                identified_solution=identified_solution,
                solution_drivers=solution_drivers,
                strategy=strategy,
                inputs=inputs,
                outputs=outputs,
                outcomes=outcomes,
                impact=impact,
                expected_results=expected_results,
                sustainability_plan =sustainability_plan,
                user_responsible=user_responsible,
            )
            solution_tree.save()
            solution_tree.stakeholders.set(stakeholders)
            solution_tree.beneficiaries.set(beneficiaries)
            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                solution_tree.support_document.add(*new_documents)
                
            # Convert ManyToMany fields to lists of names for the email context
            stakeholder_names = [stakeholder.name for stakeholder in solution_tree.stakeholders.all()]
            beneficiary_names = [beneficiary.name for beneficiary in solution_tree.beneficiaries.all()]

            # Send email notification
            email_subject = 'New Solution Tree Created'
            email_body = render_to_string('backend/project/solution_tree/Emails/SolutionTree_Assigned_Email.html', {
                'first_name': user_responsible.user.first_name,
                'last_name': user_responsible.user.last_name,
                'core_problem': solution_tree.core_problem.name,
                'identified_solution': solution_tree.identified_solution,
                'inputs': solution_tree.inputs,
                'outputs': solution_tree.outputs,
                'outcomes': solution_tree.outcomes,
                'impact': solution_tree.impact,
                'expected_results': solution_tree.expected_results,
                'stakeholders': stakeholder_names,
                'beneficiaries': beneficiary_names,
                'strategy': solution_tree.strategy,
                'Organization': webdata.title,
            })
            event_email = EmailMessage(
                email_subject,
                email_body,
                to=[user_responsible.user.email],
            )
            event_email.content_subtype = 'html'
            event_email.send()

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add solution tree success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added solution tree for core problem {solution_tree.core_problem.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Solution tree added successfully.')
            return redirect('list_solution_trees')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add solution tree failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding solution tree at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_solution_tree')

    context = {
        "users": users,
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "core_problems": CoreProblem.objects.all(),
        "stakeholders": Stakeholder.objects.all(),
        "beneficiaries": Beneficiary.objects.all(),
    }

    return render(request, 'backend/project/solution_tree/add_solution_tree.html', context)

@login_required
@block_all_roles
def list_solution_trees(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    solution_trees = SolutionTree.objects.all().order_by('-created_at')
    # Pagination
    paginator = Paginator(solution_trees, 10)
    page = request.GET.get('page')

    try:
        solution_trees_page = paginator.page(page)
    except PageNotAnInteger:
        solution_trees_page = paginator.page(1)
    except EmptyPage:
        solution_trees_page = paginator.page(paginator.num_pages)

    context = {
        "webdata":webdata,
        "solution_trees": solution_trees_page,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/solution_tree/list_solution_trees.html', context)

@login_required
@block_all_roles
def edit_solution_tree(request, slug):
    webdata = WebData.objects.first()
    solution_tree = get_object_or_404(SolutionTree, slug=slug)
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    users = User.objects.filter(Q(is_staff=True) | Q(is_superuser=True)).distinct()
    previous_user_responsible = solution_tree.user_responsible
    
    if request.method == 'POST':
        try:
            solution_tree.identified_solution = request.POST.get('identified_solution')
            solution_tree.solution_drivers = request.POST.get('solution_drivers')
            solution_tree.strategy = request.POST.get('strategy')
            solution_tree.inputs = request.POST.get('inputs')
            solution_tree.outputs = request.POST.get('outputs')
            solution_tree.outcomes = request.POST.get('outcomes')
            solution_tree.impact = request.POST.get('impact')
            solution_tree.expected_results = request.POST.get('expected_results')
            solution_tree.sustainability_plan = request.POST.get('sustainability_plan')
            solution_tree.user_responsible = get_object_or_404(UserProfile, id=request.POST.get('user_responsible'))
            solution_tree.stakeholders.set(request.POST.getlist('stakeholders'))
            solution_tree.beneficiaries.set(request.POST.getlist('beneficiaries'))
            solution_tree.save()
            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                solution_tree.support_document.add(*new_documents)
            
            # Send email if the responsible user has changed or remains the same
            if solution_tree.user_responsible != previous_user_responsible:
                # No need to fetch user profile again, it's already the user_responsible object
                user_responsible_profile = solution_tree.user_responsible
                stakeholder_names = [stakeholder.name for stakeholder in solution_tree.stakeholders.all()]
                beneficiary_names = [beneficiary.name for beneficiary in solution_tree.beneficiaries.all()]

                email_subject = f"Updated Responsibility for Solution Tree: {solution_tree.core_problem.name}"
                email_body = render_to_string('backend/project/solution_tree/Emails/SolutionTree_Assigned_Email.html', {
                    'first_name': user_responsible_profile.user.first_name,
                    'last_name': user_responsible_profile.user.last_name,
                    'core_problem': solution_tree.core_problem.name,
                    'identified_solution': solution_tree.identified_solution,
                    'strategy': solution_tree.strategy,
                    'inputs': solution_tree.inputs,
                    'outputs': solution_tree.outputs,
                    'outcomes': solution_tree.outcomes,
                    'impact': solution_tree.impact,
                    'expected_results': solution_tree.expected_results,
                    'stakeholders': stakeholder_names,
                    'beneficiaries': beneficiary_names,
                    'Organization': webdata.title,
                })
                event_email = EmailMessage(
                    email_subject,
                    email_body,
                    to=[user_responsible_profile.user.email],
                )
                event_email.content_subtype = 'html'
                event_email.send()



            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit solution tree success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated solution tree for core problem {solution_tree.core_problem.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Solution tree updated successfully.')
            return redirect('list_solution_trees')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit solution tree failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating solution tree at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('edit_solution_tree', slug=solution_tree.slug)

    context = {
        "users": users,
        "webdata":webdata,
        "solution_tree": solution_tree,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "core_problems": CoreProblem.objects.all(),
        "stakeholders": Stakeholder.objects.all(),
        "beneficiaries": Beneficiary.objects.all(),
        "solution_tree_beneficiary_ids": solution_tree.beneficiaries.values_list('id', flat=True),
        "solution_tree_stakeholder_ids": solution_tree.stakeholders.values_list('id', flat=True),
    }

    return render(request, 'backend/project/solution_tree/edit_solution_tree.html', context)

@login_required
@block_all_roles
def delete_solution_tree(request, slug):
    solution_tree = get_object_or_404(SolutionTree, slug=slug)

    if request.method == 'POST':
        try:
            solution_tree.delete()
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete solution tree success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted solution tree for core problem {solution_tree.core_problem.name} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Solution tree deleted successfully.')
            return redirect('list_solution_trees')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete solution tree failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting solution tree at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('view_solution_tree', slug=slug)

    context = {
        "solution_tree": solution_tree,
    }

    return render(request, 'backend/solution_tree/delete_solution_tree.html', context)



# RESULT 
@login_required
@block_all_roles
def add_result(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            project = get_object_or_404(Project, id=request.POST.get('project'))
            output = request.POST.get('output')
            outcome = request.POST.get('outcome')
            results_achieved = request.POST.get('results_achieved')
            evidence_of_change = request.POST.getlist('evidence_of_change')
            global_contribution = request.POST.get('global_contribution')
            regional_contribution = request.POST.get('regional_contribution')
            national_contribution = request.POST.get('national_contribution')
            local_level_contribution = request.POST.get('local_level_contribution')
            is_achieved = request.POST.get('is_achieved') == 'on'
            gender_inequities_addressed = request.POST.get('gender_inequities_addressed') == 'on'
            climate_change_addressed = request.POST.get('climate_change_addressed') == 'on'
            how_gender_inequities_addressed = request.POST.get('how_gender_inequities_addressed')
            how_climate_change_addressed = request.POST.get('how_climate_change_addressed')
            

            result = Result(
                project=project,
                output=output,
                outcome=outcome,
                results_achieved=results_achieved,
                global_contribution=global_contribution,
                regional_contribution=regional_contribution,
                national_contribution=national_contribution,
                local_level_contribution=local_level_contribution,
                is_achieved=is_achieved,
                gender_inequities_addressed=gender_inequities_addressed,
                climate_change_addressed=climate_change_addressed,
                how_gender_inequities_addressed=how_gender_inequities_addressed,
                how_climate_change_addressed=how_climate_change_addressed,
            )
            result.save()
            result.evidence_of_change.set(evidence_of_change)
            # Handle support document
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                result.support_document.add(*new_documents)
            

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add result success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added result for project {result.project.title} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Result added successfully.')
            return redirect('list_results')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add result failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding result at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_result')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "projects": Project.objects.all(),
        "indicators": Indicator.objects.all(),
    }

    return render(request, 'backend/project/result/add_result.html', context)

@login_required
@block_all_roles
def list_results(request):
    results = Result.objects.all()
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    # Pagination
    paginator = Paginator(results, 10)
    page = request.GET.get('page')

    try:
        results_page = paginator.page(page)
    except PageNotAnInteger:
        results_page = paginator.page(1)
    except EmptyPage:
        results_page = paginator.page(paginator.num_pages)


    context = {
        "webdata":webdata,
        "results": results_page,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/project/result/list_results.html', context)

@login_required
@block_all_roles
def edit_result(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    result = get_object_or_404(Result, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            
            project = get_object_or_404(Project, id=request.POST.get('project'))
            result.project = project
            result.output = request.POST.get('output')
            result.outcome = request.POST.get('outcome')
            result.results_achieved = request.POST.get('results_achieved')
            result.global_contribution = request.POST.get('global_contribution')
            result.regional_contribution = request.POST.get('regional_contribution')
            result.national_contribution = request.POST.get('national_contribution')
            result.local_level_contribution = request.POST.get('local_level_contribution')
            result.is_achieved = request.POST.get('is_achieved') == 'on'
            result.gender_inequities_addressed = request.POST.get('gender_inequities_addressed') == 'on'
            result.climate_change_addressed = request.POST.get('climate_change_addressed') == 'on'
            result.how_gender_inequities_addressed = request.POST.get('how_gender_inequities_addressed')
            result.how_climate_change_addressed = request.POST.get('how_climate_change_addressed')
            result.evidence_of_change.set(request.POST.getlist('evidence_of_change'))
            result.save()
            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                result.support_document.add(*new_documents)
            
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit result success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated result for project {result.project.title} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Result updated successfully.')
            return redirect('list_results')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit result failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating result at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('edit_result', slug=result.slug)

    context = {
        "result": result,
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "projects": Project.objects.all(),
        "indicators": Indicator.objects.all(),
        "result_evidence_of_change_ids": result.evidence_of_change.values_list('id', flat=True),
        
    }

    return render(request, 'backend/project/result/edit_result.html', context)

@login_required
@block_all_roles
def delete_result(request, slug):
    result = get_object_or_404(Result, slug=slug)

    if request.method == 'POST':
        try:
            result.delete()

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete result success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted result for project {result.project.title} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Result deleted successfully.')
            return redirect('list_results')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete result failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting result at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('view_result', slug=slug)

    context = {
        "result": result,
    }

    return render(request, 'backend/result/delete_result.html', context)



# MILESTONE
@login_required
@block_all_roles
def add_milestone(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            name = request.POST.get('name')
            description = request.POST.get('description')
            start_date = request.POST.get('start_date')
            end_date = request.POST.get('end_date')
            project = get_object_or_404(Project, id=request.POST.get('project'))
            is_achieved = request.POST.get('is_achieved') == 'True'
            date_of_achievement = request.POST.get('date_of_achievement')
            cost = request.POST.get('cost')

            milestone = Milestone(
                name=name,
                description=description,
                start_date=start_date,
                end_date=end_date,
                project=project,
                is_achieved=is_achieved,
                date_of_achievement=date_of_achievement,
                cost=cost,
            )
            milestone.save()
            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                milestone.support_document.add(*new_documents)

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add milestone success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) added milestone {milestone.name} for project {milestone.project.title} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Milestone added successfully.')
            return redirect('list_milestones')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Add milestone failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when adding milestone at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('add_milestone')

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "projects": Project.objects.all(),
    }

    return render(request, 'backend/project/milestone/add_milestone.html', context)

@login_required
@block_all_roles
def list_milestones(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    milestones_list = Milestone.objects.all().order_by('-start_date')

    # Pagination
    paginator = Paginator(milestones_list, 10)
    page = request.GET.get('page')

    try:
        milestones_page = paginator.page(page)
    except PageNotAnInteger:
        milestones_page = paginator.page(1)
    except EmptyPage:
        milestones_page = paginator.page(paginator.num_pages)

    context = {
        "webdata":webdata,
        "milestones": milestones_page,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }

    return render(request, 'backend/project/milestone/list_milestones.html', context)


@login_required
@block_all_roles
def edit_milestone(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    milestone = get_object_or_404(Milestone, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        try:
            milestone.name = request.POST.get('name')
            milestone.description = request.POST.get('description')
            milestone.start_date = request.POST.get('start_date')
            milestone.end_date = request.POST.get('end_date')
            milestone.project = get_object_or_404(Project, id=request.POST.get('project'))
            milestone.is_achieved = request.POST.get('is_achieved') == 'True'
            milestone.date_of_achievement = request.POST.get('date_of_achievement')
            milestone.cost = request.POST.get('cost')
            milestone.save()
            
            if 'support_document' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('support_document'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                milestone.support_document.add(*new_documents)

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit milestone success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) updated milestone {milestone.name} for project {milestone.project.title} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Milestone updated successfully.')
            return redirect('list_milestones')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Edit milestone failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when updating milestone at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('edit_milestone', slug=milestone.slug)

    context = {
        "webdata":webdata,
        "milestone": milestone,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "projects": Project.objects.all(),
    }

    return render(request, 'backend/project/milestone/edit_milestone.html', context)

@login_required
@block_all_roles
def delete_milestone(request, slug):
    milestone = get_object_or_404(Milestone, slug=slug)
    if request.method == 'POST':
        try:
            milestone.delete()

            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete milestone success',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) deleted milestone {milestone.name} for project {milestone.project.title} successfully at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            messages.success(request, 'Milestone deleted successfully.')
            return redirect('list_milestones')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            auth_view = AuthSignupView()
            ip_address = request.META.get('REMOTE_ADDR')
            user_agent = request.META.get('HTTP_USER_AGENT')
            auth_view.log_activity(
                request.user,
                'Delete milestone failed',
                f'User {request.user.first_name} {request.user.last_name} ({request.user.email}) encountered an error {str(e)} when deleting milestone at {timezone.now()}',
                ip_address=ip_address,
                user_agent=user_agent,
            )
            return redirect('view_milestone', slug=slug)

    context = {
        "milestone": milestone,
    }

    return render(request, 'backend/milestone/delete_milestone.html', context)
@login_required
@block_all_roles
# calendar
def calendar(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }
    return render(request, 'backend/apps/calendar/calendar.html', context)

@login_required
@block_all_roles
def get_events(request):
    events = Calendar.objects.all()
    data = [
        {
            'id': event.id,
            'title': event.title,
            'start': event.start.isoformat(),
            'end': event.end.isoformat(),
            'description': event.description,
            'className': event.color_code.lower(),
        }
        for event in events
    ]
    return JsonResponse(data, safe=False)

@login_required
@block_all_roles
@csrf_exempt
def save_event(request):
    if request.method == 'POST':
        data = json.loads(request.body)
        event_id = data.get('id')

        # Map lowercase color codes to the correct format
        color_map = {
            'primary': 'Primary',
            'info': 'Info',
            'success': 'Success',
            'danger': 'Danger',
        }

        if event_id:
            # Update an existing event
            event = get_object_or_404(Calendar, id=event_id)
            event.title = data.get('title', event.title)
            event.start = data.get('start', event.start)
            event.end = data.get('end', event.end)
            event.description = data.get('description', event.description)
            event.color_code = color_map.get(data.get('type').lower(), event.color_code)
            event.badge = data.get('badge', event.badge)
            event.save()
            return JsonResponse({'status': 'success', 'message': 'Event updated successfully', 'id': event.id})
        else:
            # Create a new event
            event = Calendar(
                title=data.get('title'),
                start=data.get('start'),
                end=data.get('end'),
                description=data.get('description'),
                color_code=color_map.get(data.get('type').lower(), 'Primary'),
                badge=data.get('badge')
            )
            event.save()
            return JsonResponse({'status': 'success', 'message': 'Event created successfully', 'id': event.id})
    
    return JsonResponse({'status': 'error', 'message': 'Invalid request method'})


def register_volunteer(request):
    webdata = WebData.objects.first()
    latest_privacy_policy = PrivacyPolicy.objects.order_by('-uploaded_at').first()
    latest_volunteer_agreement = VolunteerAgreement.objects.order_by('-uploaded_at').first()
    latest_terms_and_conditions = TermsAndConditions.objects.order_by('-uploaded_at').first()

    if request.method == 'POST':
        try:
            user_email = request.POST.get('email', '').strip()
            if Volunteer.objects.filter(email=user_email).exists():
                raise IntegrityError("A volunteer registration already exists for this email.")

            # Retrieve data from the form
            name = request.POST.get('name', '').strip()
            phone = request.POST.get('phone', '').strip()
            start_date_str = request.POST.get('start_date', '').strip()
            end_date_str = request.POST.get('end_date', '').strip()
            role_description = request.POST.get('role_description', '').strip()
            additional_info = request.POST.get('additional_info', '').strip()
            volunteer_type = request.POST.get('volunteer_type', 'COMMUNITY_SERVICE')
            emergency_contact_name = request.POST.get('emergency_contact_name', '').strip()
            emergency_contact_phone = request.POST.get('emergency_contact_phone', '').strip()
            emergency_contact_email = request.POST.get('emergency_contact_email', '').strip()
            volunteer_agreement_accepted = request.POST.get('volunteer_agreement_accepted') == 'on'

            # Converting dates
            start_date = parse_date(start_date_str)
            end_date = parse_date(end_date_str)

            # Handling profile picture (optional)
            profile_picture = request.FILES.get('profile_picture')

            
            volunteer = Volunteer(
                name=name,
                email=user_email,
                phone=phone,
                start_date=start_date,
                end_date=end_date,
                additional_info=additional_info,
                volunteer_type=volunteer_type,
                role_description=role_description,
                volunteer_agreement_accepted=volunteer_agreement_accepted,
                emergency_contact_name=emergency_contact_name,
                emergency_contact_phone=emergency_contact_phone,
                emergency_contact_email=emergency_contact_email,
                profile_picture=profile_picture,
                is_active=False
            )
            volunteer.save()  

            
            if 'licenses' in request.FILES:
                for document in request.FILES.getlist('licenses'):
                    license_doc = SupportDocument(file=document)
                    license_doc.save()  
                    volunteer.licenses.add(license_doc)
                    
            # Update the calendar entry
            update_calendar_entry(volunteer)

            messages.success(request, 'You have successfully registered as a volunteer.')

            return redirect('register_volunteer_success')

        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            logger.error(f'Error registering volunteer: {str(e)}')
            return redirect('register_volunteer')

    context = {
        "webdata": webdata,
        'latest_privacy_policy': latest_privacy_policy,
        "volunteer_types": Volunteer.VOLUNTEER_TYPES,
        'latest_volunteer_agreement': latest_volunteer_agreement,
        'latest_terms_and_conditions': latest_terms_and_conditions,
    }

    return render(request, 'backend/volunteer/Register_volunteer.html', context)

def register_volunteer_success(request):
    return render(request, 'backend/volunteer/Thank_volunteer.html')

def update_calendar_entry(volunteer):
    # Group volunteers by date and type
    date_to_volunteers = {}
    volunteers = Volunteer.objects.filter(start_date__lte=volunteer.end_date, end_date__gte=volunteer.start_date)

    for vol in volunteers:
        if vol.start_date <= volunteer.end_date and vol.end_date >= volunteer.start_date:
            date_to_volunteers.setdefault(vol.start_date, []).append(vol)

    # Create or update calendar entry based on the group end_date and individual start_date
    for date, volunteers_on_date in date_to_volunteers.items():
        # Get the maximum end date for the group of volunteers on this date
        latest_end_date = max(vol.end_date for vol in volunteers_on_date)

        # Get the count of volunteer types
        types = [vol.volunteer_type for vol in volunteers_on_date]
        type_counts = Counter(types)
        summary = ", ".join([f"{count} {v_type}" for v_type, count in type_counts.items()])

        # Build volunteer type summary for the description
        volunteer_types_summary = "; ".join([f"{count} {v_type}" for v_type, count in type_counts.items()])

        # Check for existing calendar entry
        existing_entry = Calendar.objects.filter(
            start=datetime.combine(volunteer.start_date, datetime.min.time()),
            end=datetime.combine(latest_end_date, datetime.min.time())
        ).first()

        if existing_entry:
            # Update existing entry
            existing_entry.title = f"Volunteer Availability: {sum(type_counts.values())} Volunteers"
            existing_entry.description = (
                f"A total of {sum(type_counts.values())} volunteers are available from {volunteer.start_date} "
                f"to {latest_end_date}. Volunteer types: {volunteer_types_summary}."
            )
            existing_entry.volunteers_summary = summary
            existing_entry.save()  # Save the updates
        else:
            # Create new calendar entry
            Calendar.objects.create(
                title=f"Volunteer Availability: {sum(type_counts.values())} Volunteers",
                start=datetime.combine(volunteer.start_date, datetime.min.time()),  # use individual volunteer's start date
                end=datetime.combine(latest_end_date, datetime.min.time()),  # use the group's latest end date
                color_code='Success',
                badge='Activity',
                description=(
                    f"A total of {sum(type_counts.values())} volunteers are available from {volunteer.start_date} "
                    f"to {latest_end_date}. Volunteer types: {volunteer_types_summary}."
                ),
                volunteers_summary=summary,
            )

def edit_volunteer(request, volunteer_id):
    volunteer = get_object_or_404(Volunteer, id=volunteer_id)
    
    webdata = WebData.objects.first()
    latest_privacy_policy = PrivacyPolicy.objects.order_by('-uploaded_at').first()
    latest_volunteer_agreement = VolunteerAgreement.objects.order_by('-uploaded_at').first()
    latest_terms_and_conditions = TermsAndConditions.objects.order_by('-uploaded_at').first()

    if request.method == 'POST':
        try:
            name = request.POST.get('name').strip()
            phone = request.POST.get('phone').strip()
            email  = request.POST.get('email').strip()
            additional_info  = request.POST.get('additional_info').strip()
            profile_picture = request.FILES.get('profile_picture') if 'profile_picture' in request.FILES else volunteer.profile_picture
            volunteer_type = request.POST.get('volunteer_type', 'COMMUNITY_SERVICE')
            start_date_str = request.POST.get('start_date').strip()
            end_date_str = request.POST.get('end_date').strip()
            role_description = request.POST.get('role_description').strip()
            emergency_contact_name = request.POST.get('emergency_contact_name').strip()
            emergency_contact_phone = request.POST.get('emergency_contact_phone').strip()
            emergency_contact_email = request.POST.get('emergency_contact_email').strip()
            volunteer_agreement_accepted = request.POST.get('volunteer_agreement_accepted') == 'on'

            start_date = parse_date(start_date_str)
            end_date = parse_date(end_date_str)
            
            volunteer.name = name
            volunteer.phone = phone
            volunteer.email = email
            volunteer.additional_info = additional_info
            volunteer.profile_picture = profile_picture
            volunteer.volunteer_type = volunteer_type
            volunteer.start_date = start_date
            volunteer.end_date = end_date
            volunteer.role_description = role_description
            volunteer.emergency_contact_name = emergency_contact_name
            volunteer.emergency_contact_phone = emergency_contact_phone
            volunteer.emergency_contact_email = emergency_contact_email
            volunteer.volunteer_agreement_accepted = volunteer_agreement_accepted
            volunteer.save()
            if 'licenses' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('licenses'):
                    license_doc = SupportDocument(file=document)
                    license_doc.save()
                    new_documents.append(license_doc)
                volunteer.licenses.add(*new_documents)
                
                
            # Update the calendar entry
            update_calendar_entry(volunteer)

            messages.success(request, 'Volunteer information has been updated successfully.')
            return redirect('register_volunteer_success')

        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')
            logger.error(f'Error updating volunteer: {str(e)}')
            return redirect('edit_volunteer', volunteer_id=volunteer_id)

    context = {
        "webdata": webdata,
        "volunteer": volunteer,        
        'latest_privacy_policy': latest_privacy_policy,
        'latest_volunteer_agreement': latest_volunteer_agreement,
        'latest_terms_and_conditions': latest_terms_and_conditions,
        'volunteer_types': Volunteer.VOLUNTEER_TYPES,
    }

    return render(request, 'backend/volunteer/edit_volunteer.html', context)

def update_calendar_after_deletion(start_date):
    # Convert start_date to a datetime object for filtering
    start_datetime = datetime.combine(start_date, datetime.min.time())
    end_datetime = datetime.combine(start_date, datetime.max.time())

    # Make the start and end datetimes aware
    start_datetime = timezone.make_aware(start_datetime)
    end_datetime = timezone.make_aware(end_datetime)

    # Fetch volunteers who are available on the given start date
    volunteers = Volunteer.objects.filter(start_date__lte=start_date, end_date__gte=start_date)

    # If no volunteers are available for the date, delete the calendar entry
    if not volunteers.exists():
        # Attempt to delete the corresponding calendar entry
        deleted_count, _ = Calendar.objects.filter(start=start_datetime, end=end_datetime).delete()
        if deleted_count > 0:
            print(f"Deleted calendar entry for {start_datetime} to {end_datetime}.")
        return  # Exit the function after deletion

    # Group volunteers by date
    date_to_volunteers = {}
    for vol in volunteers:
        date_to_volunteers.setdefault(vol.start_date, []).append(vol)

    # Update or create calendar entries
    for date, volunteers_on_date in date_to_volunteers.items():
        latest_end_date = max(vol.end_date for vol in volunteers_on_date)

        # Make the latest end date aware
        latest_end_date = timezone.make_aware(datetime.combine(latest_end_date, datetime.min.time()))

        # Get volunteer types and counts
        types = [vol.volunteer_type for vol in volunteers_on_date]
        type_counts = Counter(types)
        summary = ", ".join([f"{count} {v_type}" for v_type, count in type_counts.items()])
        volunteer_types_summary = "; ".join([f"{count} {v_type}" for v_type, count in type_counts.items()])

        # Check for existing calendar entry
        existing_entry = Calendar.objects.filter(
            start=start_datetime,
            end=latest_end_date
        ).first()

        if existing_entry:
            # Update existing calendar entry
            existing_entry.title = f"Volunteer Availability: {sum(type_counts.values())} Volunteers"
            existing_entry.description = (
                f"A total of {sum(type_counts.values())} volunteers are available from {date} "
                f"to {latest_end_date}. Volunteer types: {volunteer_types_summary}."
            )
            existing_entry.volunteers_summary = summary
            existing_entry.save()
            print(f"Updated calendar entry for {date} to {latest_end_date}.")
        else:
            # Create a new calendar entry if one doesn't exist
            Calendar.objects.create(
                title=f"Volunteer Availability: {sum(type_counts.values())} Volunteers",
                start=start_datetime,
                end=latest_end_date,
                color_code='Success',
                badge='Activity',
                description=(
                    f"A total of {sum(type_counts.values())} volunteers are available from {date} "
                    f"to {latest_end_date}. Volunteer types: {volunteer_types_summary}."
                ),
                volunteers_summary=summary,
            )
            print(f"Created new calendar entry for {date} to {latest_end_date}.")


@block_all_roles
def delete_volunteer(request, slug):
    volunteer = get_object_or_404(Volunteer, slug=slug)
    
    if request.method in ['POST', 'GET']:
        try:
            start_date = volunteer.start_date
            
            # Call the update_calendar_before_deletion function
            update_calendar_after_deletion(start_date)

            # Now delete the volunteer
            volunteer.delete()
            messages.success(request, f'Volunteer {volunteer.name} has been successfully deleted.')

        except Exception as e:
            messages.error(request, f'An error occurred while deleting the volunteer: {str(e)}') 
            return redirect('all_volunteers')
    
    return redirect('all_volunteers')

@login_required
@block_all_roles

def all_volunteers(request):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    latest_privacy_policy = PrivacyPolicy.objects.order_by('-uploaded_at').first()
    latest_volunteer_agreement = VolunteerAgreement.objects.order_by('-uploaded_at').first()
    latest_terms_and_conditions = TermsAndConditions.objects.order_by('-uploaded_at').first()
    
    volunteer_list = Volunteer.objects.all()
    volunteer_count = volunteer_list.count() 
    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        "volunteer_list":volunteer_list,
        "volunteer_count":volunteer_count,
        
        "latest_privacy_policy": latest_privacy_policy,
        "latest_volunteer_agreement": latest_volunteer_agreement,
        "latest_terms_and_conditions": latest_terms_and_conditions,
        
    }
    return render(request, 'backend/volunteer/All-volunteer-table.html', context)

@login_required
@block_all_roles
def download_volunteer_list_excel(request):
    # Create an in-memory workbook
    wb = openpyxl.Workbook()
    ws = wb.active
    ws.title = 'Volunteers'

    # Define the headers
    headers = [
        'Name', 'Email', 'Phone', 'Volunteer Type', 'Start Date', 'End Date',  
        'Emergency Contact Name', 
        'Emergency Contact Phone', 'Emergency Contact Email', 'Date Applied'
    ]
    ws.append(headers)

    # Get the volunteer list
    volunteers = Volunteer.objects.order_by('-date_applied')

    # Append volunteer data
    for volunteer in volunteers:
        ws.append([
            volunteer.name,
            volunteer.email,
            volunteer.phone,
            volunteer.get_volunteer_type_display(),  
            volunteer.start_date.strftime('%Y-%m-%d') if volunteer.start_date else '',
            volunteer.end_date.strftime('%Y-%m-%d') if volunteer.end_date else '',
            volunteer.emergency_contact_name,
            volunteer.emergency_contact_phone,
            volunteer.emergency_contact_email,
        ])

    # Set the content type and attachment headers
    response = HttpResponse(content_type='application/vnd.openxmlformats-officedocument.spreadsheetml.sheet')
    response['Content-Disposition'] = 'attachment; filename=volunteer_list.xlsx'

    # Save the workbook to the response
    wb.save(response)

    return response

@login_required
@block_all_roles
def notes_list(request):
    user = request.user
    user_profile = user.userprofile
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == "GET":
        notes = Note.objects.filter(user=user_profile)
        unique_tags = notes.values_list('tag', flat=True).distinct()
        tags = Note.TAG_CHOICES
    
    context = {
        "tags": tags,
        "notes": notes,
        "unique_tags": unique_tags,
        "user_profile": user_profile,
        "notifications": notifications,
        
    }
    return render(request, 'backend/Note.html', context)

@login_required
@block_all_roles
@csrf_exempt
def get_users_and_tags(request):
    if request.method == "GET":
        users = User.objects.filter(
            Q(is_staff=True) |
            Q(is_superuser=True)
        ).distinct().values('username')
        tags = Note.TAG_CHOICES

        users_list = [{'username': user['username']} for user in users]
        tags_list = [tag[0] for tag in tags]

        return JsonResponse({
            'users': users_list,
            'tags': tags_list,
        })

    return JsonResponse({'success': False, 'message': 'Invalid request method.'})

@login_required
@block_all_roles
@csrf_exempt
def save_note(request):
    if request.method == "POST":
        data = json.loads(request.body)
        user = request.user.userprofile  # Get the logged-in user's profile

        if data.get('id'):
            try:
                note = Note.objects.get(id=data['id'], user=user)  # Ensure the user owns the note
                note.title = data['title']
                note.description = data['description']
                note.tag = data['tag']
            except Note.DoesNotExist:
                return JsonResponse({'success': False, 'message': 'Note not found or access denied.'})
        else:
            note = Note(
                title=data['title'],
                description=data['description'],
                tag=data['tag'],
                user=user,
            )
        note.save()

        return JsonResponse({
            'success': True,
            'note': {
                'id': note.id,
                'title': note.title,
                'description': note.description,
                'tag': note.tag,
                'user': note.user.user.username,
                'thumb': note.thumb,
                'date': note.date.strftime('%d/%m/%Y'),
                'isFav': note.isFav,
            }
        })

    return JsonResponse({'success': False, 'message': 'Invalid request method.'})

@login_required
@block_all_roles
@csrf_exempt
def delete_note(request):
    if request.method == "POST":
        data = json.loads(request.body)
        note_id = data.get('id')
        user = request.user.userprofile

        try:
            note = Note.objects.get(id=note_id, user=user) 
            note.delete()
            return JsonResponse({'success': True})
        except Note.DoesNotExist:
            return JsonResponse({'success': False, 'message': 'Note not found or access denied.'})

    return JsonResponse({'success': False, 'message': 'Invalid request method.'})

@login_required
@block_all_roles
@csrf_exempt
def set_fav_note(request):
    if request.method == "POST":
        data = json.loads(request.body)
        note_id = data.get('id')
        user = request.user.userprofile

        try:
            note = Note.objects.get(id=note_id, user=user)  # Ensure the user owns the note
            note.isFav = not note.isFav
            note.save()
            return JsonResponse({'success': True, 'isFav': note.isFav})
        except Note.DoesNotExist:
            return JsonResponse({'success': False, 'message': 'Note not found or access denied.'})

    return JsonResponse({'success': False, 'message': 'Invalid request method.'})

@login_required
@block_all_roles
@csrf_exempt
def set_tag(request):
    if request.method == "POST":
        data = json.loads(request.body)
        note_id = data.get('id')
        new_tag = data.get('tag')
        user = request.user.userprofile

        try:
            note = Note.objects.get(id=note_id, user=user)  # Ensure the user owns the note
            note.tag = new_tag
            note.save()
            return JsonResponse({'success': True, 'tag': note.tag})
        except Note.DoesNotExist:
            return JsonResponse({'success': False, 'message': 'Note not found or access denied.'})

    return JsonResponse({'success': False, 'message': 'Invalid request method.'})

@login_required
@block_all_roles
def Progress_report(request):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == "GET":
        progress_reports = ProgressReport.objects.all().order_by('-created_at')
        
        # Add user-specific statuses to progress reports
        progress_reports_with_status = []
        for report in progress_reports:
            status = report.get_status_for_user(user)
            progress_reports_with_status.append({
                'report': report,
                'status': status
            })

    context = {
        "webdata":webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        
        "progress_reports_with_status": progress_reports_with_status,
    }
    return render(request, 'backend/ProgressReport.html', context)


@login_required
@block_all_roles
def get_progress_users_tags_and_priorities(request):
    if request.method == "GET":
        # users = UserProfile.objects.filter(user__is_staff=True)
        users = UserProfile.objects.all()
        users_list = [{'username': user.user.username} for user in users]
        tags = ProgressReport.TAG_CHOICES
        priorities = ProgressReport.PRIORITY_CHOICES
        tags_list = [tag[0] for tag in tags]
        priorities_list = [priority[0] for priority in priorities]
        projects = Project.objects.all().values('id','title')

        return JsonResponse({
            'users': users_list,
            'tags': tags_list,
            'priorities': priorities_list,
            'projects': list(projects),
        })

    return JsonResponse({'success': False, 'message': 'Invalid request method.'})

@login_required
@block_all_roles
@csrf_exempt
def add_progress_report(request):
    if request.method == 'POST':
        try:
            data = json.loads(request.body)
            title = data.get('title')
            user_assignee_username = data.get('user_assignee')
            progress_report_priority = data.get('progress_report_priority')
            progress_report_tags = data.get('progress_report_tags')
            description = data.get('description')
            def get_instance(model, data):
                try:
                    return model.objects.get(id=data['id']) if data and 'id' in data else None
                except model.DoesNotExist:
                    return None
            project = get_instance(Project, json.loads(data.get('project')) if data.get('project') else None)
            volunteer_profile = get_instance(UserProfile, json.loads(data.get('volunteer_profile')) if data.get('volunteer_profile') else None)
            
            if not title:
                return JsonResponse({'success': False, 'message': 'Title is required'})
            user_assignee = None
            if user_assignee_username:
                try:
                    user_assignee = UserProfile.objects.get(user__username=user_assignee_username)
                except UserProfile.DoesNotExist:
                    return JsonResponse({'success': False, 'message': 'Assignee not found'})
            progress_report = ProgressReport(
                title=title,
                user_profile=request.user.userprofile,
                user_assignee=user_assignee,
                progress_report_priority=progress_report_priority,
                progress_report_tags=progress_report_tags,
                description=description,
                project=project,
                volunteer_profile=volunteer_profile,
            )
            progress_report.save()
            return JsonResponse({'success': True, 'message': 'Progress report added successfully', 'progress_report': progress_report.id})
        
        except Exception as e:
            return JsonResponse({'success': False, 'message': str(e)})
    
    return JsonResponse({'success': False, 'message': 'Invalid request method'})

@login_required
@block_all_roles
@csrf_exempt
def update_progress_report(request, report_id):
    if request.method == 'POST':
        try:
            data = json.loads(request.body)
            try:
                progress_report = ProgressReport.objects.get(id=report_id)
            except ProgressReport.DoesNotExist:
                return JsonResponse({'success': False, 'message': 'Progress report not found'})
            title = data.get('title')
            user_assignee_username = data.get('user_assignee')
            progress_report_priority = data.get('progress_report_priority')
            progress_report_tags = data.get('progress_report_tags')
            description = data.get('description')
            def get_instance(model, data):
                try:
                    return model.objects.get(id=data['id']) if data and 'id' in data else None
                except model.DoesNotExist:
                    return None
            project = get_instance(Project, json.loads(data.get('project')) if data.get('project') else None)
            volunteer_profile = get_instance(UserProfile, json.loads(data.get('volunteer_profile')) if data.get('volunteer_profile') else None)

            if not title:
                return JsonResponse({'success': False, 'message': 'Title is required'})
            user_assignee = None
            if user_assignee_username:
                try:
                    user_assignee = UserProfile.objects.get(user__username=user_assignee_username)
                except UserProfile.DoesNotExist:
                    return JsonResponse({'success': False, 'message': 'Assignee not found'})

            progress_report.title = title
            progress_report.user_assignee = user_assignee
            progress_report.progress_report_priority = progress_report_priority
            progress_report.progress_report_tags = progress_report_tags
            progress_report.description = description
            progress_report.project = project
            progress_report.volunteer_profile = volunteer_profile
            
            progress_report.save()
            return JsonResponse({'success': True, 'message': 'Progress report updated successfully', 'progress_report': progress_report.id})
        
        except Exception as e:
            return JsonResponse({'success': False, 'message': f'Error updating progress report: {str(e)}'})
    
    return JsonResponse({'success': False, 'message': 'Invalid request method'})

@login_required
@block_all_roles
@csrf_exempt
def trash_report(request, report_id):
    if request.method == 'POST':
        try:
            user = request.user
            progress_report = ProgressReport.objects.get(id=report_id)
            user_report_status, created = UserReportStatus.objects.get_or_create(user=user, report=progress_report)
            user_report_status.status = 'trash'
            user_report_status.save()
            return JsonResponse({'success': True, 'message': 'Progress report moved to trash'})
        except ProgressReport.DoesNotExist:
            return JsonResponse({'success': False, 'message': 'Progress report not found'})
        except Exception as e:
            return JsonResponse({'success': False, 'message': str(e)})
    return JsonResponse({'success': False, 'message': 'Invalid request method'})

@login_required
@block_all_roles
@csrf_exempt
def restore_report(request, report_id):
    if request.method == 'POST':
        try:
            user = request.user
            progress_report = ProgressReport.objects.get(id=report_id)
            user_report_status, created = UserReportStatus.objects.get_or_create(user=user, report=progress_report)
            user_report_status.status = ''
            user_report_status.save()
            return JsonResponse({'success': True, 'message': 'Progress report restored'})
        except ProgressReport.DoesNotExist:
            return JsonResponse({'success': False, 'message': 'Progress report not found'})
        except Exception as e:
            return JsonResponse({'success': False, 'message': str(e)})
    return JsonResponse({'success': False, 'message': 'Invalid request method'})

@login_required
@block_all_roles
@csrf_exempt
def set_report_seen(request, report_id):
    
    if request.method == 'POST':
        try:
            user = request.user
            progress_report = ProgressReport.objects.get(id=report_id)
            user_report_status, created = UserReportStatus.objects.get_or_create(user=user, report=progress_report)
            user_report_status.status = 'seen'
            user_report_status.save()
            return JsonResponse({'success': True, 'message': 'Progress report marked as seen', 'is_seen': True})
        except ProgressReport.DoesNotExist:
            return JsonResponse({'success': False, 'message': 'Progress report not found'})
        except Exception as e:
            return JsonResponse({'success': False, 'message': str(e)})
    return JsonResponse({'success': False, 'message': 'Invalid request method'})

@csrf_exempt
@login_required
@block_all_roles
def set_report_important(request, report_id):
    if request.method == 'POST':
        try:
            user = request.user
            progress_report = ProgressReport.objects.get(id=report_id)
            user_report_status, created = UserReportStatus.objects.get_or_create(user=user, report=progress_report)
            user_report_status.status = 'important' if user_report_status.status != 'important' else ''
            user_report_status.save()
            return JsonResponse({'success': True, 'message': 'Progress report marked as important', 'is_important': user_report_status.status == 'important'})
        except ProgressReport.DoesNotExist:
            return JsonResponse({'success': False, 'message': 'Progress report not found'})
        except Exception as e:
            return JsonResponse({'success': False, 'message': str(e)})
    return JsonResponse({'success': False, 'message': 'Invalid request method'})


@login_required
def project_framework_pdf(request, slug):
    # Get the project project by slug
    project = get_object_or_404(Project, slug=slug)
    webdata = WebData.objects.first()

    # Prepare the context data in the required format
    context = {
        'project': project,
        "webdata":webdata,
        'activities': project.activities.all(),
        'results': project.results.all(),
        'solution_trees': project.solution_trees.all(),
    }

    # Render the HTML template with context data
    html_string = render(request, 'backend/project/project_framework_pdf.html', context).content.decode('utf-8')

    # Create a file-like buffer to receive PDF data
    buffer = BytesIO()

    # Create PDF
    pisa_status = pisa.CreatePDF(html_string, dest=buffer)

    # If error then show some funny view
    if pisa_status.err:
        return HttpResponse('We had some errors <pre>' + html_string + '</pre>')

    # Return PDF as response
    response = HttpResponse(buffer.getvalue(), content_type='application/pdf')
    # response['Content-Disposition'] = f'attachment; filename="{project.title}_framework.pdf"'
    
    return response

def add_organization_file(request):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        name = request.POST.get('name')
        file = request.FILES.get('file') 
        
        if name and file: 
            organization_file = OrganizationFile(name=name, file=file)  # Set the file directly
            organization_file.save() 
            messages.success(request, 'Organization File added successfully!')
            return redirect('Dashboard')
        else:
            messages.error(request, 'Invalid data. Please make sure all fields are filled correctly.')
            return redirect('add_organization_file')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/apps/documents/add_organization_file.html', context)

@login_required
@block_all_roles
def edit_organization_file(request, pk):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    organization_file = get_object_or_404(OrganizationFile, pk=pk)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        name = request.POST.get('name')
        new_file = request.FILES.get('file')

        if name:
            organization_file.name = name
        
        if new_file:
            organization_file.file = new_file

        organization_file.save()
        messages.success(request, 'Organization File updated successfully!')
        return redirect('Dashboard')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        'organization_file': organization_file,
    }

    return render(request, 'backend/apps/documents/edit_organization_file.html', context)

@login_required
@block_all_roles
def delete_organization_file(request, pk):
    organization_file = get_object_or_404(OrganizationFile, pk=pk)

    if request.method == 'POST':
        organization_file.delete()
        messages.success(request, 'Organization File deleted successfully!')
        return redirect('Dashboard')
    
    messages.error(request, 'Invalid request method for deleting Organization File.')
    return redirect('Dashboard')

# Add User File
@login_required
def add_user_file(request):
    user_profile = request.user.userprofile  # Get user profile
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        name = request.POST.get('name')
        file = request.FILES.get('file')  # Get the single file

        if name and file:
            user_file = UserFile(user=user_profile, name=name, file=file)  # Use user_profile here
            user_file.save()
            messages.success(request, 'User File added successfully!')
            return redirect('Dashboard')
        else:
            messages.error(request, 'Invalid data. Please make sure all fields are filled correctly.')
            return redirect('add_user_file')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/apps/documents/add_user_file.html', context)

# Edit User File
@login_required
def edit_user_file(request, pk):
    user_profile = request.user.userprofile  # Get user profile
    webdata = WebData.objects.first()
    user_file = get_object_or_404(UserFile, pk=pk)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        name = request.POST.get('name')
        new_file = request.FILES.get('file')  # Get the new file if provided

        if name:
            user_file.name = name

        if new_file:  # Update file if a new one is provided
            user_file.file = new_file

        user_file.save()  # Save the changes
        messages.success(request, 'Your File has been uploaded successfully!')
        return redirect('Dashboard')
    messages.error(request, 'We could not upload Your File, contact Developer.')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        'user_file': user_file,
    }

    return render(request, 'backend/apps/documents/edit_user_file.html', context)

# Delete User File
@login_required
def delete_user_file(request, pk):
    user_file = get_object_or_404(UserFile, pk=pk)

    if request.method == 'POST':
        user_file.delete()  # Delete the user file
        messages.success(request, 'User File deleted successfully!')
        return redirect('Dashboard')
    messages.error(request, 'Invalid request method for deleting Your File.')
    return redirect('Dashboard')

@login_required
@block_all_roles
def add_meeting_minutes(request):
    user_profile = request.user.userprofile
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        meeting_title = request.POST.get('meeting_title')
        meeting_date_str = request.POST.get('meeting_date')  
        attendees = request.POST.get('attendees')
        agenda = request.POST.get('agenda')
        minutes = request.POST.get('minutes')
        aobs = request.POST.get('aobs')
        previous_meeting_seconded_by = request.POST.get('previous_meeting_seconded_by')
        members_absent_with_apologies = request.POST.get('members_absent_with_apologies')
        members_absent_without_apologies = request.POST.get('members_absent_without_apologies')
        
        if not minutes:
            messages.error(request, 'Minutes cannot be empty. Please fill out the minutes field.')
            return redirect('add_meeting_minutes')
        
        try:
            meeting_date = parse_datetime(meeting_date_str)
            if not meeting_date:
                raise ValueError("Invalid date format")
            meeting_date = timezone.make_aware(meeting_date, timezone.get_current_timezone())
    

            # Create the meeting minutes with the parsed date
            meeting_minutes = Minutes.objects.create(
                meeting_title=meeting_title,
                meeting_date=meeting_date,
                attendees=attendees,
                agenda=agenda,
                minutes=minutes,
                aobs=aobs,
                previous_meeting_seconded_by=previous_meeting_seconded_by,
                members_absent_with_apologies=members_absent_with_apologies,
                members_absent_without_apologies=members_absent_without_apologies,
                created_by=user_profile,
            )
            if 'file' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('file'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                meeting_minutes.file.add(*new_documents)
                
            messages.success(request, 'Meeting minutes added successfully!')
            
            return redirect('Dashboard')  # Redirect to a list view after adding
        except ValueError as e:
            messages.error(request, f'Error adding meeting minutes: {str(e)}. Please ensure the date is correct.')
        except Exception as e:
            messages.error(request, f'Error adding meeting minutes: {str(e)}')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }
    
    return render(request, 'backend/apps/documents/add_meeting_minutes.html', context)

@login_required
@block_all_roles
def edit_meeting_minutes(request, slug):
    webdata = WebData.objects.first()
    user_profile = request.user.userprofile
    meeting_minutes = get_object_or_404(Minutes, slug=slug)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        meeting_minutes.meeting_title = request.POST.get('meeting_title')
        meeting_date_str = request.POST.get('meeting_date')  
        attendees = request.POST.get('attendees')
        agenda = request.POST.get('agenda')
        minutes = request.POST.get('minutes')
        aobs = request.POST.get('aobs')
        previous_meeting_seconded_by = request.POST.get('previous_meeting_seconded_by', '')
        members_absent_with_apologies = request.POST.get('members_absent_with_apologies', '')
        members_absent_without_apologies = request.POST.get('members_absent_without_apologies', '')
        
        
        try:
            
            meeting_date = parse_datetime(meeting_date_str)
            if not meeting_date:
                raise ValueError("Invalid date format")

            
            meeting_minutes.meeting_date = meeting_date
            meeting_minutes.attendees = attendees
            meeting_minutes.agenda = agenda
            meeting_minutes.minutes = minutes
            meeting_minutes.aobs = aobs
            meeting_minutes.previous_meeting_seconded_by = previous_meeting_seconded_by
            meeting_minutes.members_absent_with_apologies = members_absent_with_apologies
            meeting_minutes.members_absent_without_apologies = members_absent_without_apologies

            
            meeting_minutes.save()
            if 'file' in request.FILES:
                new_documents = []
                for document in request.FILES.getlist('file'):
                    support_document = SupportDocument(file=document)
                    support_document.save()
                    new_documents.append(support_document)
                meeting_minutes.file.add(*new_documents)
            messages.success(request, 'Meeting minutes updated successfully!')
            return redirect('Dashboard')  
        except ValueError as e:
            messages.error(request, f'Error updating meeting minutes: {str(e)}. Please ensure the date is correct.')
        except Exception as e:
            messages.error(request, f'Error updating meeting minutes: {str(e)}')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
        "meeting_minutes": meeting_minutes,
    }
    
    return render(request, 'backend/apps/documents/edit_meeting_minutes.html', context)


@login_required
@block_all_roles
def delete_meeting_minutes(request, slug):
    meeting_minutes = get_object_or_404(Minutes, slug=slug)
    if request.method == 'POST':
        try:
            # Find the related calendar entry based on the meeting title and meeting date
            calendar_event = Calendar.objects.filter(
                title=meeting_minutes.meeting_title,
                start=meeting_minutes.meeting_date
            ).first()

            # Delete the calendar event if it exists
            if calendar_event:
                calendar_event.delete()

            # Delete the meeting minutes
            meeting_minutes.delete()
            messages.success(request, 'Meeting minutes and calendar event deleted successfully!')
        except Exception as e:
            # Add an error message if something goes wrong
            messages.error(request, f'Error deleting meeting minutes: {str(e)}')

        return redirect('Dashboard')  # Redirect to the dashboard or a relevant page

    # If not POST request, just redirect to dashboard
    messages.error(request, 'Invalid request method!')
    return redirect('Dashboard')


@login_required
def download_meeting_minutes_pdf(request, slug): 
    meeting_minutes = get_object_or_404(Minutes, slug=slug)
    webdata = WebData.objects.first()
    
    # Split lists only on line breaks to keep items together as single entries.
    attendees_list = [attendee.strip() for attendee in meeting_minutes.attendees.replace('\r\n', '\n').split('\n') if attendee.strip()]
    agenda_list = [agenda_item.strip() for agenda_item in meeting_minutes.agenda.replace('\r\n', '\n').split('\n') if agenda_item.strip()]
    aobs_list = [aob.strip() for aob in meeting_minutes.aobs.replace('\r\n', '\n').split('\n') if aob.strip()]
    members_absent_with_apologies_list = [member.strip() for member in meeting_minutes.members_absent_with_apologies.replace('\r\n', '\n').split('\n') if member.strip()]
    members_absent_without_apologies_list = [member.strip() for member in meeting_minutes.members_absent_without_apologies.replace('\r\n', '\n').split('\n') if member.strip()]

    buffer = BytesIO()
    p = canvas.Canvas(buffer, pagesize=letter)
    width, height = letter  

    # Title and Date
    p.setFont("Helvetica-Bold", 16)
    p.drawCentredString(width / 2, height - 50, meeting_minutes.meeting_title)
    p.setFont("Helvetica", 12)
    p.drawCentredString(width / 2, height - 70, f"Date: {meeting_minutes.meeting_date.strftime('%B %d, %Y')}")

    # Add some vertical space
    y_position = height - 100

    # Function to draw bullet points with wrapping and page break handling
    def draw_bullet_points(title, items, y_pos):
        nonlocal p, width, height
        text_width = width - 100  # Define maximum text width for wrapped lines

        p.setFont("Helvetica-Bold", 12)
        p.drawString(50, y_pos, title)
        y_pos -= 20
        p.setFont("Helvetica", 12)

        for item in items:
            if y_pos < 50:  # Start a new page if space is low
                p.showPage()
                p.setFont("Helvetica-Bold", 12)
                p.drawCentredString(width / 2, height - 50, meeting_minutes.meeting_title)
                p.setFont("Helvetica", 12)
                p.drawCentredString(width / 2, height - 70, f"Date: {meeting_minutes.meeting_date.strftime('%B %d, %Y')}")
                y_pos = height - 100

            # Wrap long lines within the bullet item
            lines = item.splitlines()
            for line in lines:
                while line:
                    line_to_draw = line
                    while p.stringWidth(line_to_draw) > text_width:
                        line_to_draw = line_to_draw.rsplit(' ', 1)[0]
                    p.drawString(70, y_pos, f"- {line_to_draw}")
                    y_pos -= 15
                    line = line[len(line_to_draw):].lstrip()

            y_pos -= 10  # Extra space between list items
        return y_pos

    # Draw attendees, AOBs, and absentees
    y_position = draw_bullet_points("Attendees:", attendees_list, y_position)
    y_position = draw_bullet_points("Members Absent with Apologies:", members_absent_with_apologies_list, y_position)
    y_position = draw_bullet_points("Members Absent without Apologies:", members_absent_without_apologies_list, y_position)

    # Agenda
    y_position = draw_bullet_points("Agenda:", agenda_list, y_position)

    # Minutes
    y_position -= 20
    p.setFont("Helvetica-Bold", 12)
    p.drawString(50, y_position, "Minutes:")
    y_position -= 20
    p.setFont("Helvetica", 12)

    # Convert the HTML formatted minutes back to plain text
    soup = BeautifulSoup(meeting_minutes.minutes, 'html.parser')
    formatted_minutes = soup.get_text(separator="\n\n")  # Use "\n\n" to separate paragraphs
    text_width = width - 100

    # Handle line breaks in formatted minutes text to prevent overlap
    for paragraph in formatted_minutes.split('\n\n'):  # Process by paragraph
        for line in paragraph.splitlines():
            if y_position < 50:  # Start new page if space is low
                p.showPage()
                p.setFont("Helvetica-Bold", 12)
                p.drawCentredString(width / 2, height - 50, meeting_minutes.meeting_title)
                p.setFont("Helvetica", 12)
                p.drawCentredString(width / 2, height - 70, f"Date: {meeting_minutes.meeting_date.strftime('%B %d, %Y')}")
                y_position = height - 100

            # Wrap long lines
            while line:
                line_to_draw = line
                while p.stringWidth(line_to_draw) > text_width:
                    line_to_draw = line_to_draw.rsplit(' ', 1)[0]
                p.drawString(70, y_position, line_to_draw)
                y_position -= 15
                line = line[len(line_to_draw):].lstrip()

        y_position -= 15  # Extra space between paragraphs

    # Add the user who added the minutes
    y_position -= 20
    y_position = draw_bullet_points("AOBs (Any Other Business):", aobs_list, y_position)
    
    # Seconded information
    y_position -= 20 
    p.setFont("Helvetica", 12)
    if meeting_minutes.previous_meeting_seconded_by:
        p.drawString(50, y_position, f"Previous Minutes Seconded by: {meeting_minutes.previous_meeting_seconded_by}")
    else:
        p.drawString(50, y_position, "Previous Meeting Minutes not seconded.")
    y_position -= 15

    # Organization name from webdata
    y_position -= 20 
    organization_name = webdata.title if webdata else "_" 
    p.drawString(50, y_position, f'Minutes for : Climate Health and Wellness Medical camp. ({meeting_minutes.meeting_title})')

    # Save the PDF with the meeting title
    p.showPage()
    p.save()

    buffer.seek(0)
    
    # Set the response with the correct filename
    response = HttpResponse(buffer, content_type='application/pdf')
    response['Content-Disposition'] = f'attachment; filename="{meeting_minutes.meeting_title}.pdf"'
    return response


@login_required
@block_all_roles

def add_privacy_policy(request):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        title = request.POST.get('title')
        document = request.FILES.get('document')

        if title and document:
            policy = PrivacyPolicy(title=title, document=document)
            policy.save()
            messages.success(request, 'Privacy Policy added successfully!')
            return redirect('Dashboard')  
        else:
            messages.error(request, 'Invalid data. Please make sure all fields are filled correctly.')
            return redirect('add_privacy_policy')
    
    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/apps/documents/add_privacy_policy.html', context)
@login_required
@block_all_roles
def edit_privacy_policy(request, pk):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    policy = get_object_or_404(PrivacyPolicy, pk=pk)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        title = request.POST.get('title')
        document = request.FILES.get('document')

        if title:
            policy.title = title
        
        if document:
            policy.document = document
        
        policy.save()
        messages.success(request, 'Privacy Policy updated successfully!')
        return redirect('Dashboard')
    
    context = {
        'policy': policy,
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/apps/documents/edit_privacy_policy.html', context)

@login_required
@block_all_roles
def delete_privacy_policy(request, pk):
    policy = get_object_or_404(PrivacyPolicy, pk=pk)

    if request.method == 'POST':
        policy.delete()
        messages.success(request, 'Privacy Policy deleted successfully!')
        return redirect('Dashboard')
    
    messages.error(request, 'Invalid request method for deleting policy.')
    return redirect('Dashboard')

@login_required
@block_all_roles
def add_terms_and_conditions(request):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        title = request.POST.get('title')
        document = request.FILES.get('document')

        if title and document:
            terms = TermsAndConditions(title=title, document=document)
            terms.save()
            messages.success(request, 'Terms and Conditions added successfully!')
            return redirect('Dashboard')  
        else:
            messages.error(request, 'Invalid data. Please make sure all fields are filled correctly.')
            return redirect('add_terms_and_conditions')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/apps/documents/add_terms_and_conditions.html', context)

@login_required
@block_all_roles
def edit_terms_and_conditions(request, pk):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    terms = get_object_or_404(TermsAndConditions, pk=pk)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        title = request.POST.get('title')
        document = request.FILES.get('document')

        if title:
            terms.title = title
        
        if document:
            terms.document = document
        
        terms.save()
        messages.success(request, 'Terms and Conditions updated successfully!')
        return redirect('Dashboard')

    context = {
        'terms': terms,
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/apps/documents/edit_terms_and_conditions.html', context)

@login_required
@block_all_roles
def delete_terms_and_conditions(request, pk):
    terms = get_object_or_404(TermsAndConditions, pk=pk)

    if request.method == 'POST':
        terms.delete()
        messages.success(request, 'Terms and Conditions deleted successfully!')
        return redirect('Dashboard')
    
    messages.error(request, 'Invalid request method for deleting Terms and Conditions.')
    return redirect('Dashboard')


@login_required
@block_all_roles
def add_volunteer_agreement(request):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        title = request.POST.get('title')
        document = request.FILES.get('document')

        if title and document:
            agreement = VolunteerAgreement(title=title, document=document)
            agreement.save()
            messages.success(request, 'Volunteer Agreement added successfully!')
            return redirect('Dashboard')  
        else:
            messages.error(request, 'Invalid data. Please make sure all fields are filled correctly.')
            return redirect('add_volunteer_agreement')

    context = {
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/apps/documents/add_volunteer_agreement.html', context)

@login_required
@block_all_roles
def edit_volunteer_agreement(request, pk):
    user = request.user
    user_profile = user.userprofile
    webdata = WebData.objects.first()
    agreement = get_object_or_404(VolunteerAgreement, pk=pk)
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    if request.method == 'POST':
        title = request.POST.get('title')
        document = request.FILES.get('document')

        if title:
            agreement.title = title
        
        if document:
            agreement.document = document
        
        agreement.save()
        messages.success(request, 'Volunteer Agreement updated successfully!')
        return redirect('Dashboard')

    context = {
        'agreement': agreement,
        "webdata": webdata,
        "user_profile": user_profile,
        "notifications": notifications,
    }

    return render(request, 'backend/apps/documents/edit_volunteer_agreement.html', context)

@login_required
@block_all_roles
def delete_volunteer_agreement(request, pk):
    agreement = get_object_or_404(VolunteerAgreement, pk=pk)

    if request.method == 'POST':
        agreement.delete()
        messages.success(request, 'Volunteer Agreement deleted successfully!')
        return redirect('Dashboard')
    
    messages.error(request, 'Invalid request method for deleting Volunteer Agreement.')
    return redirect('Dashboard')

@login_required
@block_all_roles
def add_camp_item(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        item_description = request.POST.get('item_description', '').strip()
        volunteer_id = request.POST.get('volunteer_id', None)
        partnering_organization_id = request.POST.get('partnering_organization_id', None)
        items = request.FILES.get('items')

        try:
            volunteer = Volunteer.objects.get(id=volunteer_id) if volunteer_id else None
            partnering_organization = PartneringOrganization.objects.get(id=partnering_organization_id) if partnering_organization_id else None

            camp_item = CampItem(
                item_description=item_description,
                volunteer=volunteer,
                partnering_organization=partnering_organization,
                items=items,
                
            )
            camp_item.save()
            messages.success(request, 'Camp Item saved successfully!')
            return redirect('camp_item_list')

        except Volunteer.DoesNotExist:
            messages.error(request, 'Volunteer does not exist.')
        except PartneringOrganization.DoesNotExist:
            messages.error(request, 'Partnering Organization does not exist.')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')

    volunteers = Volunteer.objects.all()
    organizations = PartneringOrganization.objects.all()
    
    context = {
        "webdata": webdata,
        "notifications": notifications,
        "volunteers": volunteers, 
        "organizations": organizations
    }
    return render(request, 'backend/Camp/CampItems/add_camp_item.html', context)

@login_required
@block_all_roles
def edit_camp_item(request, item_id):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    camp_item = get_object_or_404(CampItem, id=item_id)

    if request.method == 'POST':
        camp_item.item_description = request.POST.get('item_description', camp_item.item_description).strip()
        volunteer_id = request.POST.get('volunteer_id', None)
        partnering_organization_id = request.POST.get('partnering_organization_id', None)
        

        try:
            camp_item.volunteer = Volunteer.objects.get(id=volunteer_id) if volunteer_id else None
            camp_item.partnering_organization = PartneringOrganization.objects.get(id=partnering_organization_id) if partnering_organization_id else None
            camp_item.items = request.FILES.get('items') if 'items' in request.FILES else camp_item.items
            camp_item.save()
        
            messages.success(request, 'Camp Item updated successfully!')
            return redirect('camp_item_list')

        except Volunteer.DoesNotExist:
            messages.error(request, 'Volunteer does not exist.')
        except PartneringOrganization.DoesNotExist:
            messages.error(request, 'Partnering Organization does not exist.')
        except Exception as e:
            messages.error(request, f'An error occurred: {str(e)}')

    volunteers = Volunteer.objects.all()
    organizations = PartneringOrganization.objects.all()
    
    context = {
        "webdata": webdata,
        "notifications": notifications,
        "volunteers": volunteers, 
        "organizations": organizations,
        'camp_item': camp_item,
    }
    
    return render(request, 'backend/Camp/CampItems/edit_camp_item.html', context)

@login_required
@block_all_roles
def delete_camp_item(request, pk):
    camp_item = get_object_or_404(CampItem, pk=pk)

    if request.method == 'POST':
        try:
            camp_item.delete()
            messages.success(request, 'Camp Item deleted successfully!')
        except Exception as e:
            messages.error(request, f'An error occurred while deleting: {str(e)}')
        return redirect('camp_item_list') 

    return redirect('camp_item_list')

@login_required
@block_all_roles
def camp_item_list(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    camp_items = CampItem.objects.all()
    workshopschoices = WorkshopChoice.objects.all()
    participants = Participant.objects.all()
    
    
    servicechoices = ServiceChoice.objects.all()
    healthservices = HealthService.objects.all()
    feedbacks = Feedback.objects.all()
    treeplantings = TreePlanting.objects.all()
    participantworkshops = ParticipantWorkshop.objects.all()

    context = {
        "webdata": webdata,
        "notifications": notifications,
        "camp_items": camp_items,
        "workshopschoices":workshopschoices,
        "participants":participants,
        "servicechoices":servicechoices,
        "healthservices":healthservices,
        "feedbacks":feedbacks,
        "treeplantings":treeplantings,
        "participantworkshops":participantworkshops,
        
    }
    return render(request, 'backend/Camp/CampItems/camp_items.html', context)

@login_required
@block_all_roles
def download_camp_items_csv(request):
    # Create the HttpResponse object with CSV headers
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = 'attachment; filename="camp_items.csv"'

    # Create a CSV writer
    writer = csv.writer(response)

    # Write the header row
    writer.writerow(['Item Description', 'Volunteer', 'Partnering Organization', 'Image URL'])

    # Query all camp items
    camp_items = CampItem.objects.all()

    # Write data rows
    for item in camp_items:
        volunteer = item.volunteer.name if item.volunteer else 'N/A'
        organization = item.partnering_organization.name if item.partnering_organization else 'N/A'
        
        # Construct the full image URL
        image_url = request.build_absolute_uri(item.items.url) if item.items else 'N/A'
        
        writer.writerow([item.item_description, volunteer, organization, image_url])

    return response

def add_participant(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    if request.method == 'POST':
        name = request.POST.get('name')
        phone = request.POST.get('phone')
        email = request.POST.get('email')
        age = request.POST.get('age')
        sex = request.POST.get('sex')
        if not name:
            messages.error(request, 'Name field is required.')
            return redirect('add_participant')
        try:
            
            age = int(age) if age else None
            participant = Participant(name=name, phone=phone, email=email, age=age, sex=sex)
            participant.save()
            messages.success(request, 'Participant added successfully.')
            return redirect('add_participant')
        
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect('add_participant')
        
    context = {
        "webdata": webdata,
        "notifications": notifications,
    }
    return render(request, 'backend/Camp/participants/add_participant.html', context)

@login_required
@block_all_roles
def delete_participant(request, pk):
    participant = get_object_or_404(Participant, pk=pk)

    if request.method == 'POST':
        try:
            participant.delete()
            messages.success(request, 'Participant deleted successfully.')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
        return redirect('camp_item_list')
    
    return redirect('camp_item_list')

@login_required
@is_moderator
def add_workshop_choice(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        workshop_title = request.POST.get('workshop_title')
        workshop_description = request.POST.get('workshop_description')

        if not workshop_title:
            messages.error(request, 'Title field is required.')
            return redirect('add_workshop_choice')

        if WorkshopChoice.objects.filter(workshop_title=workshop_title).exists():
            messages.error(request, 'A workshop with this title already exists.')
            return redirect('add_workshop_choice')

        # Automatically assign the logged-in user as the workshop officer
        workshop_officer = request.user.userprofile

        if not workshop_officer.is_moderator:
            messages.error(request, 'You must be a workshop practitioner to create a workshop choice.')
            return redirect('add_workshop_choice')

        try:
            # Create and save the new WorkshopChoice
            workshop_choice = WorkshopChoice(
                workshop_title=workshop_title,
                workshop_officer=workshop_officer,
                workshop_description=workshop_description,
            )
            
            workshop_choice.full_clean()  # Call full_clean to trigger the clean method
            workshop_choice.save()
            messages.success(request, 'Workshop choice added successfully.')
            return redirect('Dashboard')
        except ValidationError as ve:
            messages.error(request, f"Validation error: {', '.join(ve.messages)}")
            return redirect('Dashboard')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect('Dashboard')

    context = {
        "webdata": webdata,
        "notifications": notifications,
    }
    return render(request, 'backend/Camp/workshops/add_workshop_choice.html', context)

class WorkshopChoiceDeleteView(View):
    def post(self, request, pk):
        workshop = get_object_or_404(WorkshopChoice, pk=pk)
        
        if workshop.workshop_officer == request.user.userprofile:
            workshop.delete()
            messages.success(request, f'{workshop.workshop_title} has been deleted successfully.')
        else:
            messages.error(request, 'You do not have permission to delete this workshop.')

        return redirect('Dashboard')
    
@login_required
@is_moderator
def add_participant_workshop(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    participants = Participant.objects.all()
    user_profile = UserProfile.objects.get(user=request.user)
    workshops = WorkshopChoice.objects.filter(workshop_officer=user_profile)

    if request.method == 'POST':
        participant_count = request.POST.get('participant_count')
        selected_workshops = request.POST.getlist('workshops')
        lessons_learned = request.POST.get('lessons_learned')

        
        try:
            for workshop_id in selected_workshops:
                workshop = WorkshopChoice.objects.get(id=workshop_id)
                participant_workshop = ParticipantWorkshop(
                    participant_count=participant_count,
                    workshop=workshop,
                    lessons_learned=lessons_learned,
                )
                participant_workshop.save()
            
            messages.success(request, 'Participant workshops added successfully.')
            return redirect('Dashboard')
        
        except WorkshopChoice.DoesNotExist:
            messages.error(request, 'One or more selected workshops do not exist.')
            return redirect('add_participant_workshop')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect('add_participant_workshop')

    context = {
        "webdata": webdata,
        "notifications": notifications,
        "participants": participants,
        "workshops": workshops,
    }
    return render(request, 'backend/Camp/participant_workshops/add_participant_workshop.html', context)

@login_required
@is_moderator
def delete_participant_workshop(request, pk):
    # Get the ParticipantWorkshop instance
    participant_workshop = get_object_or_404(ParticipantWorkshop, pk=pk)

    # Ensure that the user is a workshop practitioner and owns the workshop
    if not request.user.userprofile.is_moderator:  # Check if the user is a workshop practitioner
        messages.error(request, "You do not have permission to delete this entry.")
        return redirect('dashboard')

    # Check if the workshop officer is the user trying to delete the workshop
    if participant_workshop.workshop.workshop_officer.user != request.user:
        messages.error(request, "You do not have permission to delete this entry.")
        return redirect('dashboard')

    # Proceed to delete the instance
    participant_workshop.delete()
    messages.success(request, "Participant workshop deleted successfully.")
    return redirect('Dashboard')

@login_required
@is_moderator
def download_participant_workshop_csv(request):
    
    user_profile = get_object_or_404(UserProfile, user=request.user)
    if not user_profile.is_moderator:
        messages.error(request, "You do not have permission to download this report.")
        return redirect('dashboard')

    # Get workshops associated with the workshop officer
    workshops = WorkshopChoice.objects.filter(workshop_officer=user_profile)

    # Get ParticipantWorkshop entries for the workshops
    participant_workshops = ParticipantWorkshop.objects.filter(workshop__in=workshops)

    # Create CSV response
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = 'attachment; filename="participants_in_workshops.csv"'

    writer = csv.writer(response)
    writer.writerow(['Participants Attended', 'Workshop Title', 'Lessons Learned/Taught']) 

    for participant_workshop in participant_workshops:
        writer.writerow([
            participant_workshop.participant_count,
            participant_workshop.workshop.workshop_title,
            participant_workshop.lessons_learned,
        ])

    return response

@login_required
@is_nurse
def add_service_choice(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        service_title = request.POST.get('service_title')
        service_description = request.POST.get('service_description')

        if not service_title:
            messages.error(request, 'Service title is required.')
            return redirect('add_service_choice')

        if ServiceChoice.objects.filter(service_title=service_title).exists():
            messages.error(request, 'A service with this title already exists.')
            return redirect('add_service_choice')

        try:
            
            service_officer = request.user.userprofile

            service_choice = ServiceChoice(
                service_title=service_title,
                service_officer=service_officer,
                service_description=service_description,
            )
            service_choice.save()
            messages.success(request, 'Service choice added successfully.')
            return redirect('Dashboard') 
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect('add_service_choice')

    context = {
        "webdata": webdata,
        "notifications": notifications,
    }
    return render(request, 'backend/Camp/services/add_service_choice.html', context)


class ServiceChoiceDeleteView(View):
    def post(self, request, pk):
        service = get_object_or_404(ServiceChoice, pk=pk)
        
        if service.service_officer == request.user.userprofile:
            service.delete()
            messages.success(request, f'{service.service_title} has been deleted successfully.')
        else:
            messages.error(request, 'You do not have permission to delete this Service.')

        return redirect('Dashboard')

@is_nurse
def add_health_service(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    # Get the user profile of the logged-in user
    user_profile = UserProfile.objects.get(user=request.user)
    
    # Get all services assigned to the user
    services = ServiceChoice.objects.filter(service_officer=user_profile)

    # Get all participants and their received services
    participants = Participant.objects.all()

    # Create a dictionary to hold participant ID and the services they have received
    participant_service_mapping = {
        participant.id: list(participant.health_services.values_list('service_id', flat=True))
        for participant in participants
    }

    if request.method == 'POST':
        participant_id = request.POST.get('participant')
        selected_services = request.POST.getlist('service')
        participant_results = request.POST.get('participant_results')
        service_officer_officer_feedback = request.POST.get('service_officer_officer_feedback')

        if not participant_id or not selected_services:
            messages.error(request, 'Participant and services are required.')
            return redirect('add_health_service')

        participant = Participant.objects.filter(id=participant_id).first()

        if not participant:
            messages.error(request, 'Invalid participant selected.')
            return redirect('add_health_service')

        try:
            for service_id in selected_services:
                service = ServiceChoice.objects.get(id=service_id)

                # Check if the participant already has this service assigned
                if HealthService.objects.filter(participant=participant, service=service).exists():
                    messages.warning(request, f"{participant.name} already has the service '{service.service_title}' assigned.")
                    continue

                # Create a new HealthService if it doesn't exist
                health_service = HealthService(
                    participant=participant,
                    service=service,
                    participant_results=participant_results,
                    service_officer_officer_feedback=service_officer_officer_feedback,
                    participated=True,
                )
                health_service.save()

            messages.success(request, 'Health service added successfully.')
            return redirect('Dashboard')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect('add_health_service')

    context = {
        "webdata": webdata,
        "notifications": notifications,
        "participants": participants,
        "services": services,
        "participant_service_mapping": participant_service_mapping,  # Pass the mapping to the template
    }
    return render(request, 'backend/Camp/services/add_health_service.html', context)



@is_doctor
def update_health_service(request, health_service_id):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    health_service = get_object_or_404(HealthService, id=health_service_id)
    participants = Participant.objects.all()
    user_profile = UserProfile.objects.get(user=request.user)
    services = ServiceChoice.objects.all()

    if request.method == 'POST':
        doctors_prescription = request.POST.get('doctors_prescription')
        doctors_feedback = request.POST.get('doctors_feedback')
        

        try:
            
            health_service.doctors_prescription = doctors_prescription
            health_service.doctors_feedback = doctors_feedback
            health_service.doctor = user_profile
            health_service.prescribed = True

            health_service.save()
            messages.success(request, 'Presciption added successfully.')
            return redirect('Dashboard')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect(reverse('update_health_service', args=[health_service_id]))

    context = {
        "webdata": webdata,
        "notifications": notifications,
        "participants": participants,
        "services": services,
        "health_service": health_service,
    }
    return render(request, 'backend/Camp/services/update_health_service.html', context)

@is_pharmacist
def prescribe(request, health_service_id):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)
    
    health_service = get_object_or_404(HealthService, id=health_service_id)
    participants = Participant.objects.all()
    user_profile = UserProfile.objects.get(user=request.user)
    services = ServiceChoice.objects.all()

    if request.method == 'POST':
        pharmacist_prescription = request.POST.get('pharmacist_prescription')
        pharmacist_feedback = request.POST.get('pharmacist_feedback')
        

        try:
            
            health_service.pharmacist_prescription = pharmacist_prescription
            health_service.pharmacist_feedback = pharmacist_feedback
            health_service.prescribed = True
            health_service.prescribed = True
            health_service.medicated = True

            health_service.save()
            messages.success(request, 'Presciption added successfully.')
            return redirect('Dashboard')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect(reverse('update_health_service', args=[health_service_id]))

    context = {
        "webdata": webdata,
        "notifications": notifications,
        "participants": participants,
        "services": services,
        "health_service": health_service,
    }
    return render(request, 'backend/Camp/services/prescribe.html', context)

@is_nurse
def delete_health_service(request, pk):
    # Get the HealthService instance
    health_service = get_object_or_404(HealthService, pk=pk)

    # Ensure the user is a medical practitioner
    if not request.user.userprofile.is_nurse:
        messages.error(request, "You do not have permission to delete this entry.")
        return redirect('dashboard')

    # Check if the service officer of the health service is the user trying to delete it
    if health_service.service.service_officer.user != request.user:
        messages.error(request, "You do not have permission to delete this entry.")
        return redirect('dashboard')

    # Proceed to delete the instance
    try:
        health_service.delete()
        messages.success(request, f"{health_service.participant.name}'s medical checkup for {health_service.service.service_title} has been deleted successfully.")
    except Exception as e:
        messages.error(request, f"An error occurred while deleting the health service: {e}")
    
    return redirect('Dashboard')

@login_required
def download_health_services_csv(request):
    # Create the HttpResponse object with the correct content type (CSV)
    response = HttpResponse(content_type='text/csv')
    response['Content-Disposition'] = 'attachment; filename="health_services.csv"'

    # Create a CSV writer
    writer = csv.writer(response)

    # Write the header row
    writer.writerow([
        'Participant Name', 'Age', 'Sex', 'Phone', 'Email', 'Service Title', 'Nurse Name', 
        'Test Results', 'Nurse Notes', 'Doctor Name', 'Doctors Prescription','Doctors Notes', 'Pharmacist Medical Provision',
        'Pharmacist Feedback'
    ])

    # Query all HealthService records and write the data to the CSV
    health_services = HealthService.objects.select_related('participant', 'service__service_officer')

    for health_service in health_services:
        participant = health_service.participant
        service = health_service.service
        officer = service.service_officer if service else None
        doctor = health_service.doctor

        writer.writerow([
            participant.name,
            participant.age if participant.age is not None else 'Not Provided',
            participant.sex if participant.sex else 'Not Provided',
            participant.phone,
            participant.email,
            service.service_title if service else 'N/A',
            officer.user.get_full_name() if officer else 'N/A',
            health_service.participant_results,
            health_service.service_officer_officer_feedback,
            doctor.user.get_full_name() if doctor else 'N/A',
            health_service.doctors_prescription,
            health_service.doctors_feedback,
            health_service.pharmacist_prescription,
            health_service.pharmacist_feedback,
            
            
        ])

    return response

def add_feedback(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    participants = Participant.objects.all()

    if request.method == 'POST':
        participant_id = request.POST.get('participant')
        feedback_text = request.POST.get('feedback')
        lessons_learned = request.POST.get('lessons_learned')

        if not participant_id or not feedback_text or not lessons_learned:
            messages.error(request, 'All fields are required.')
            return redirect('add_feedback')

        participant = Participant.objects.filter(id=participant_id).first()

        if not participant:
            messages.error(request, 'Invalid participant selected.')
            return redirect('add_feedback')

        try:
            feedback = Feedback(participant=participant, feedback=feedback_text, lessons_learned=lessons_learned)
            feedback.save()
            messages.success(request, 'Feedback added successfully.')
            return redirect('camp_item_list')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect('add_feedback')

    context = {
        "webdata": webdata,
        "notifications": notifications,
        "participants": participants,
    }
    return render(request, 'backend/Camp/feedback/add_feedback.html', context)

def delete_feedback(request, pk):
    feedback = get_object_or_404(Feedback, pk=pk)

    if request.method == 'POST':
        try:
            feedback.delete()
            messages.success(request, 'Feedback deleted successfully.')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
        return redirect('camp_item_list')

    return redirect('camp_item_list')


def add_tree_planting(request):
    webdata = WebData.objects.first()
    notifications = AdminNotifications.objects.exclude(read_by_entries__user=request.user, read_by_entries__is_read=True)

    if request.method == 'POST':
        number_of_trees = request.POST.get('number_of_trees')
        date_planted = request.POST.get('date_planted')
        start_date_of_monitoring = request.POST.get('start_date_of_monitoring')
        end_date_of_monitoring = request.POST.get('end_date_of_monitoring')
        progress_update = request.POST.get('progress_update')

        if not number_of_trees or not date_planted or not progress_update:
            messages.error(request, 'Number of trees, date planted, and progress update are required.')
            return redirect('add_tree_planting')

        try:
            tree_planting = TreePlanting(
                number_of_trees=number_of_trees,
                date_planted=date_planted,
                start_date_of_monitoring=start_date_of_monitoring,
                end_date_of_monitoring=end_date_of_monitoring,
                progress_update=progress_update
            )
            tree_planting.save()
            messages.success(request, 'Tree planting record added successfully.')
            return redirect('camp_item_list')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
            return redirect('add_tree_planting')

    context = {
        "webdata": webdata,
        "notifications": notifications,
    }
    return render(request, 'backend/Camp/tree_planting/add_tree_planting.html', context)


def delete_tree_planting(request, pk):
    tree_planting = get_object_or_404(TreePlanting, pk=pk)

    if request.method == 'POST':
        try:
            tree_planting.delete()
            messages.success(request, 'Tree planting record deleted successfully.')
        except Exception as e:
            messages.error(request, f"An error occurred: {e}")
        return redirect('tree_planting_list')

    return redirect('camp_item_list')

