from django.urls import path
from . import views
from .views import *


urlpatterns = [
    # Home
    path('', views.dashboard, name='home'),
    
    
    # Contact
    path('submit-contact-form/', views.submit_contact_form, name='submit_contact_form'),
    

    # System
    path('System/Error', views.Error, name='Error'),
    path('System/Success', views.Success, name='Success'),
    path('unauthorized/', unauthorized_access, name='unauthorized_access'),

    # Authentication
    path('logout/', views.auth_logout, name='auth_logout'),
    path('auth/signin', views.auth_signin, name='auth_signin'),
    path('auth/signup', AuthSignupView.as_view(), name='auth_signup'),

    path('delete-account/', views.delete_account, name='delete_account'),
    path('auth/change-password', views.change_password, name='change_password'),
    path('auth/password-reset', AuthEmailPasswordResetLinkView.as_view(), name='email_password_reset_link'),
    path('auth/password-reset/<uidb64>/<token>/', views.auth_password_reset_confirm, name='password_reset_confirm'),

    # Email Verification
    path('verify/<str:token>/', views.verify_email, name='verify_email'),
    path('auth/pending-verification', views.auth_wait_screen, name='wait_screen'),
    path('auth/verification-complete', views.auth_verification_failed, name='verification_failed'),
    path('auth/verification-complete', views.auth_verification_complete, name='verification_complete'),
    path('auth/resend-verification-email', views.resend_verification_email, name='resend_verification_email'),

    # Support & Maintenance
    path('Support/maintenance', views.maintenance, name='maintenance'),
    path('contact-developer/', ContactDeveloperCreateView.as_view(), name='contact-developer'),

    # Projects
    path('edit-project/<int:project_id>/', views.edit_project, name='edit_project'),
    path('post/delete/<int:project_id>/', views.delete_project, name='delete_project'),


    path('partnering-organizations/', list_partnering_organizations, name='list_partnering_organizations'),
    path('partnering-organizations/add/', add_partnering_organization, name='add_partnering_organization'),
    path('partnering-organizations/edit/<slug:slug>/', edit_partnering_organization, name='edit_partnering_organization'),
    path('partnering-organizations/delete/<slug:slug>/', delete_partnering_organization, name='delete_partnering_organization'),
    path('download-partnering-organizations/', download_partnering_organizations, name='download_partnering_organizations'),
    path('partner-feedback-support/<int:feedback_support_id>/', views.add_edit_partner_feedback_support, name='edit_partner_feedback_support'),
    path('partner-feedback-support/', views.add_edit_partner_feedback_support, name='add_partner_feedback_support'),
    

    # Dashboard & Finance
    path('dashboard', views.dashboard, name='Dashboard'),
    path('Projects/Frameworks/', views.Projects, name='Project_Frameworks'),

    # User Accounts
    path('Users/Account', views.users_account_page, name='users_account_page'),
    path('Users/Profile', views.users_profile_page, name='users_profile_page'),

    # Volunteers
    path('All/volunteers/', views.all_volunteers, name='all_volunteers'),
    path('register/volunteer/', views.register_volunteer, name='register_volunteer'),
    path('register/volunteer/success', views.register_volunteer_success, name='register_volunteer_success'),
    path('volunteer/delete/<slug:slug>/', views.delete_volunteer, name='delete_volunteer'),
    path('download-volunteer-list/', views.download_volunteer_list_excel, name='download_volunteer_list_excel'),
    path('edit-volunteer/<int:volunteer_id>/', views.edit_volunteer, name='edit_volunteer'),

    
    # Notifications
    path('mark-notification-as-read/<int:notification_id>/', mark_notification_as_read, name='mark_notification_as_read'),

    # Tags & Notes
    path('set-tag/', set_tag, name='set_tag'),
    path('notes/', notes_list, name='notes_list'),
    path('notes/save/', save_note, name='save_note'),
    path('delete-note/', delete_note, name='delete_note'),
    path('set-fav-note/', set_fav_note, name='set_fav_note'),
    path('notes/users-and-tags/', get_users_and_tags, name='get_users_and_tags'),

    # Progress Reports
    path('Progress-Report/', Progress_report, name='Progress_report'),
    path('add_progress_report/', add_progress_report, name='add_progress_report'),
    path('set_report_seen/<int:report_id>/', set_report_seen, name='set_report_seen'),
    path('set_report_important/<int:report_id>/', set_report_important, name='set_report_important'),
    path('update_progress_report/<int:report_id>/', update_progress_report, name='update_progress_report'),
    path('trash_report/<int:report_id>/', trash_report, name='trash_report'),
    path('restore_report/<int:report_id>/', restore_report, name='restore_report'),
    path('Progress-Report/users-tags-priorities/', get_progress_users_tags_and_priorities, name='get_progress_users_tags_and_priorities'),

    path('projects/<slug:slug>/framework/pdf/', project_framework_pdf, name='project_framework_pdf'),
    
    path('download-monitoring-evaluation/', download_monitoring_evaluation, name='download_monitoring_evaluation'),
    
    # projects URLs
    path('projects/add/', add_project, name='add_project'),
    path('projects/', list_projects, name='list_projects'),
    path('projects/<slug:slug>/edit/', edit_project, name='edit_project'),
    path('projects/<slug:slug>/delete/', delete_project, name='delete_project'),
    
    # Indicator URLs
    path('indicator/add/', views.add_indicator, name='add_indicator'),
    path('indicators/', views.list_indicators, name='list_indicators'),
    path('indicator/<slug:slug>/edit/', views.edit_indicator, name='edit_indicator'),
    path('indicator/<slug:slug>/delete/', views.delete_indicator, name='delete_indicator'),

    
    # Beneficiary URLs
    path('beneficiary/add/', views.add_beneficiary, name='add_beneficiary'),
    path('beneficiary/list/', views.list_beneficiaries, name='list_beneficiaries'),
    path('beneficiary/<slug:slug>/edit/', views.edit_beneficiary, name='edit_beneficiary'),
    path('beneficiary/<slug:slug>/delete/', views.delete_beneficiary, name='delete_beneficiary'),
    
    # Stakeholder URLs
    path('stakeholder/add/', add_stakeholder, name='add_stakeholder'),
    path('stakeholders/', list_stakeholders, name='list_stakeholders'),
    path('stakeholder/<slug:slug>/edit/', edit_stakeholder, name='edit_stakeholder'),
    path('stakeholder/<slug:slug>/delete/', delete_stakeholder, name='delete_stakeholder'),
    
    # Resource URLs
    path('resources/add/', add_resource, name='add_resource'),
    path('resources/', list_resources, name='list_resources'),
    path('resources/<slug:slug>/edit/', edit_resource, name='edit_resource'),
    path('resources/<slug:slug>/delete/', delete_resource, name='delete_resource'),
    
    # Activity URLs
    path('activities/add/', add_activity, name='add_activity'),
    path('activities/', list_activities, name='list_activities'),
    path('activities/<slug:slug>/edit/', edit_activity, name='edit_activity'),
    path('activities/<slug:slug>/delete/', delete_activity, name='delete_activity'),

    # CoreProblem URLs
    path('core_problems/add/', add_core_problem, name='add_core_problem'),
    path('core_problems/', list_core_problems, name='list_core_problems'),
    path('core_problems/<slug:slug>/edit/', edit_core_problem, name='edit_core_problem'),
    path('core_problems/<slug:slug>/delete/', delete_core_problem, name='delete_core_problem'),


    # SolutionTree URLs
    path('solution_trees/add/', add_solution_tree, name='add_solution_tree'),
    path('solution_trees/', list_solution_trees, name='list_solution_trees'),
    path('solution_trees/<slug:slug>/edit/', edit_solution_tree, name='edit_solution_tree'),
    path('solution_trees/<slug:slug>/delete/', delete_solution_tree, name='delete_solution_tree'),

    # Result URLs
    path('results/add/', add_result, name='add_result'),
    path('results/', list_results, name='list_results'),
    path('results/<slug:slug>/edit/', edit_result, name='edit_result'),
    path('results/<slug:slug>/delete/', delete_result, name='delete_result'),

    # Milestone URLs
    path('milestones/add/', add_milestone, name='add_milestone'),
    path('milestones/', list_milestones, name='list_milestones'),
    path('milestones/<slug:slug>/edit/', edit_milestone, name='edit_milestone'),
    path('milestones/<slug:slug>/delete/', delete_milestone, name='delete_milestone'),
    
    # Calendar URLs
    path('calendar/', calendar, name='calendar'),
    path('events/', get_events, name='get_events'),
    path('events/save/', save_event, name='save_event'),
    
    # user private files
    path('user-file/add/', add_user_file, name='add_user_file'),
    path('user-file/edit/<int:pk>/', edit_user_file, name='edit_user_file'),
    path('user-file/delete/<int:pk>/', delete_user_file, name='delete_user_file'),
    
    # Organization File URLs
    path('organization-file/add/', views.add_organization_file, name='add_organization_file'),
    path('organization-file/edit/<int:pk>/', views.edit_organization_file, name='edit_organization_file'),
    path('organization-file/delete/<int:pk>/', views.delete_organization_file, name='delete_organization_file'),
    
    # Privacy policy URLS
    path('privacy-policy/add/', views.add_privacy_policy, name='add_privacy_policy'),
    path('privacy-policy/edit/<int:pk>/', views.edit_privacy_policy, name='edit_privacy_policy'),
    path('privacy-policy/delete/<int:pk>/', views.delete_privacy_policy, name='delete_privacy_policy'),
    
    # Meeting minutes
    path('meeting-minutes/add/', add_meeting_minutes, name='add_meeting_minutes'),
    path('meeting-minutes/edit/<slug:slug>/', edit_meeting_minutes, name='edit_meeting_minutes'),
    path('meeting-minutes/delete/<slug:slug>/', delete_meeting_minutes, name='delete_meeting_minutes'),
    path('meeting-minutes/download/<slug:slug>/', download_meeting_minutes_pdf, name='download_meeting_minutes_pdf'),
    
    # Volunteer Agreement URLs
    path('volunteer-agreement/add/', views.add_volunteer_agreement, name='add_volunteer_agreement'),
    path('volunteer-agreement/edit/<int:pk>/', views.edit_volunteer_agreement, name='edit_volunteer_agreement'),
    path('volunteer-agreement/delete/<int:pk>/', views.delete_volunteer_agreement, name='delete_volunteer_agreement'),
    
    # Terms and Conditions URLs
    path('terms-and-conditions/add/', views.add_terms_and_conditions, name='add_terms_and_conditions'),
    path('terms-and-conditions/edit/<int:pk>/', views.edit_terms_and_conditions, name='edit_terms_and_conditions'),
    path('terms-and-conditions/delete/<int:pk>/', views.delete_terms_and_conditions, name='delete_terms_and_conditions'),

    # Camp Item URLs
    path('add/Camp-Item/', add_camp_item, name='add_camp_item'),
    path('camp-items/', camp_item_list, name='camp_item_list'),
    path('edit/<int:item_id>/', edit_camp_item, name='edit_camp_item'),
    path('delete/<int:pk>/', delete_camp_item, name='delete_camp_item'),
    path('download-camp-items/', download_camp_items_csv, name='download_camp_items_csv'),
    
    # Camp participants URLs --
    path('add/participant', add_participant, name='add_participant'),
    path('delete/<int:pk>/', delete_participant, name='delete_participant'),
    
    # Camp Workshop URLs--
    path('add/workshop/choice', add_workshop_choice, name='add_workshop_choice'),
    path('workshop/<int:pk>/delete/', WorkshopChoiceDeleteView.as_view(), name='workshop_delete'),
    
    # Camp Workshop Participant URLs --
    path('add/Workshop/Participant', add_participant_workshop, name='add_participant_workshop'),
    path('delete-participant-workshop/<int:pk>/', delete_participant_workshop, name='delete_participant_workshop'),
    path('download-participant-workshops/', download_participant_workshop_csv, name='download_participant_workshops'),
    
    # Camp Service Choices URLs--
    path('add/Service/Choices', add_service_choice, name='add_service_choice'),
    path('Service/<int:pk>/delete/', ServiceChoiceDeleteView.as_view(), name='delete_service_choice'),
    path('update_health_service/<int:health_service_id>/', views.update_health_service, name='update_health_service'),
    path('prescribe/<int:health_service_id>/', views.prescribe, name='prescribe'),
    
    
    # Camp Health Service URLs-
    path('add/Health/Service', add_health_service, name='add_health_service'),
    path('delete_health_service/<int:pk>/', delete_health_service, name='delete_health_service'),
    path('download_health_services/', download_health_services_csv, name='download_health_services_csv'),

    
    # Camp Feedback URLs--
    path('add/Feedback', add_feedback, name='add_feedback'),
    path('delete/<int:pk>/', delete_feedback, name='delete_feedback'),
    
    # Camp Tree Planting URLs--
    path('add/Tree/Planting', add_tree_planting, name='add_tree_planting'),
    path('delete/<int:pk>/', delete_tree_planting, name='delete_tree_planting'),
]
