from django.db import models

class Calendar(models.Model):
    COLOR_CODE_CHOICES = [
        ('Primary', 'Primary'),
        ('Info', 'Info'),
        ('Success', 'Success'),
        ('Danger', 'Danger'),
    ]

    BADGE_CHOICES = [
        ('Milestone', 'Milestone'),
        ('Activity', 'Activity'),
    ]
    title = models.CharField(max_length=255, help_text="Enter the title of the calendar event.")
    start = models.DateTimeField(help_text="Enter the start date and time for the calendar event. Example: '2024-09-01 09:00'.")
    end = models.DateTimeField(help_text="Enter the end date and time for the calendar event. Example: '2024-09-01 17:00'.")
    color_code = models.CharField(max_length=10, choices=COLOR_CODE_CHOICES, help_text="Choose a color code to represent the event. Example: 'Primary' for default styling.")
    badge = models.CharField(max_length=10, choices=BADGE_CHOICES, help_text="Choose a badge to be displayed with the event. Example: 'Milestone'.")
    description = models.TextField(help_text="Enter a description for the calendar event. Example: 'Community Health Training Session'.")
    volunteers_summary = models.TextField(blank=True, help_text="Summary of volunteers by type.")
    updated_at = models.DateTimeField(auto_now=True)
    
    def __str__(self):
        return f"{self.title}- Updated On -{self.updated_at}"

    class Meta:
        verbose_name = 'Najimudu Event Calendar'
        verbose_name_plural = 'Najimudu Events Calendar'
