from django.db import models

class WebData(models.Model):
    title = models.CharField(max_length=150, help_text="Organization name")
    mission = models.TextField(blank=True, help_text="Organization Mission")
    vision = models.TextField(blank=True, help_text="Organization Vision")
    goals = models.TextField(blank=True, help_text="Organization Goals")
    email = models.EmailField(blank=True, help_text="Organization Phone Number")
    phone = models.CharField(max_length=20, blank=True, help_text="Organization Phone Number")
    maintenance_mode = models.BooleanField(default=False, help_text="Enable maintenance mode")

    
    class Meta:
        verbose_name = 'Website Data'
        verbose_name_plural = 'Website Data'

    def __str__(self):
        return f"{self.title}"
    
    