from django.db import models

class VolunteerAgreement(models.Model):
    title = models.CharField(max_length=100)
    document = models.FileField(upload_to='volunteer_agreement/')
    uploaded_at = models.DateTimeField(auto_now_add=True)
    class Meta:
        verbose_name = 'Doc-Volunteer Agreement'
        verbose_name_plural = 'Doc-Volunteer Agreements'
    def __str__(self):
        return self.title
