from django.contrib.auth.models import User  # or use the custom user model if applicable
from django.db import models
from django.utils.text import slugify
from django.utils import timezone

class UserFile(models.Model):
    user = models.ForeignKey('UserProfile', on_delete=models.CASCADE)
    name = models.CharField(max_length=255, help_text="Name of the document")
    file = models.FileField(upload_to='user_documents/', help_text=" Private Document file to be uploaded")
    upload_date = models.DateTimeField(default=timezone.now, help_text="Date the document was uploaded")
    updated_at = models.DateTimeField(auto_now=True, help_text="Date the document was last updated")
    slug = models.SlugField(unique=True, blank=True)

    class Meta:
        verbose_name = 'Najimudu User Personal Document'
        verbose_name_plural = 'Najimudu User Personal Documents'
        unique_together = ('user', 'name')

    def save(self, *args, **kwargs):
        if not self.pk:  
            base_name = self.name
            name = base_name
            counter = 1
            while UserFile.objects.filter(user=self.user, name=name).exists():
                name = f"{base_name} ({counter})"
                counter += 1
            self.name = name

        if not self.slug:
            base_slug = slugify(f"{self.user.user.first_name}-{self.name}")  
            slug = base_slug
            counter = 1
            while UserFile.objects.filter(slug=slug).exists():
                slug = f"{base_slug}-{counter}"
                counter += 1
            self.slug = slug

        super().save(*args, **kwargs)

    def __str__(self):
        return f"{self.name} (by :{self.user.user.first_name})"  

