from django.db import models
from .UserProfile import UserProfile


class Note(models.Model):
    TAG_CHOICES = [
        ('Important', 'Important'),
        ('Completed', 'Completed'),
        ('Pending', 'Pending'),
        ('Stalled', 'Stalled'),
        ('Urgent', 'Urgent'),
        ('In Progress', 'In Progress'),
        ('On Hold', 'On Hold'),
        ('Deferred', 'Deferred'),
        ('Cancelled', 'Cancelled'),
        ('Assigned', 'Assigned'),
        ('Not Started', 'Not Started'),
        ('Under Review', 'Under Review'),
        ('Awaiting Approval', 'Awaiting Approval'),
        ('Unassigned', 'Unassigned'),
    ]

    user = models.ForeignKey(UserProfile, on_delete=models.CASCADE)
    title = models.CharField(max_length=255)
    description = models.TextField()
    date = models.DateField(auto_now_add=True)
    isFav = models.BooleanField(default=False)
    tag = models.CharField(max_length=20, choices=TAG_CHOICES)

    @property
    def thumb(self):
        if self.user.profile_picture:
            return self.user.profile_picture.url
        else:
            return '/static/assets/images/Blank-Avatar.png'

    def __str__(self):
        return self.title