from django.db import models
from .Volunteer import Volunteer
from .PartneringOrganization import PartneringOrganization

class CampItem(models.Model):
    volunteer = models.ForeignKey(Volunteer, on_delete=models.CASCADE, related_name='camp_items', null=True, blank=True)
    partnering_organization = models.ForeignKey(PartneringOrganization, on_delete=models.CASCADE, related_name='camp_items', null=True, blank=True)
    item_description = models.CharField(max_length=1000)
    items = models.ImageField(upload_to='Camp_Item_pictures/', blank=True)
    

    def __str__(self):
        # Check if there's a linked volunteer
        if self.volunteer:
            return f"{self.item_description} (Volunteer: {self.volunteer.name})"
        
        # Check if there's a linked partnering organization
        if self.partnering_organization:
            return f"{self.item_description} (Organization: {self.partnering_organization.name})"
        
        # If neither is linked
        return f"{self.item_description} (No Volunteer or Organization)"