from django.db import models
from django.contrib.auth.models import User


class AdminNotifications(models.Model):
    message = models.TextField()
    created_at = models.DateTimeField(auto_now_add=True)
    
    def __str__(self):
        return f"{self.message} created by admin on {self.created_at}"

class NotificationReadBy(models.Model):
    notification = models.ForeignKey(AdminNotifications, on_delete=models.CASCADE, related_name='read_by_entries')
    user = models.ForeignKey(User, on_delete=models.CASCADE)
    is_read = models.BooleanField(default=False)
    timestamp = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return f"{self.user.first_name} read  {self.notification} on {self.timestamp}"