# Generated by Django 5.0.2 on 2024-10-21 09:37

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('main', '0006_participant_servicechoice_treeplanting_and_more'),
    ]

    operations = [
        migrations.AlterModelOptions(
            name='feedback',
            options={'verbose_name': 'Camp Feedback', 'verbose_name_plural': 'Camp Feedback'},
        ),
        migrations.AlterModelOptions(
            name='healthservice',
            options={'verbose_name': 'Camp Health Service', 'verbose_name_plural': 'Camp Health Service'},
        ),
        migrations.AlterModelOptions(
            name='participant',
            options={'verbose_name': 'Camp Participant', 'verbose_name_plural': 'Camp Participants'},
        ),
        migrations.AlterModelOptions(
            name='participantworkshop',
            options={'verbose_name': 'Camp Participant Workshop', 'verbose_name_plural': 'Camp Participant Workshops'},
        ),
        migrations.AlterModelOptions(
            name='servicechoice',
            options={'verbose_name': 'Camp Service Choice', 'verbose_name_plural': 'Camp Service Choices'},
        ),
        migrations.AlterModelOptions(
            name='treeplanting',
            options={'verbose_name': 'Camp Tree Planting', 'verbose_name_plural': 'Camp Tree Planting'},
        ),
        migrations.AlterModelOptions(
            name='workshopchoice',
            options={'verbose_name': 'Camp Workshop Choice', 'verbose_name_plural': 'Camp Workshop Choices'},
        ),
        migrations.RenameField(
            model_name='servicechoice',
            old_name='title',
            new_name='service_title',
        ),
        migrations.RenameField(
            model_name='workshopchoice',
            old_name='title',
            new_name='workshop_title',
        ),
        migrations.AddField(
            model_name='healthservice',
            name='participant_results',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='healthservice',
            name='service_officer_officer_feedback',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='participantworkshop',
            name='lessons_learned',
            field=models.TextField(default=django.utils.timezone.now),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='servicechoice',
            name='service_description',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='servicechoice',
            name='service_officers',
            field=models.ForeignKey(help_text='Only users who are medical practitioners can be assigned here.', limit_choices_to={'is_medical_practitioner': True}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='services', to='main.userprofile'),
        ),
        migrations.AddField(
            model_name='servicechoice',
            name='slug',
            field=models.SlugField(blank=True, max_length=120, unique=True),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='is_medical_practitioner',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='userprofile',
            name='is_workshop_practitioner',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='workshopchoice',
            name='workshop_description',
            field=models.CharField(default=django.utils.timezone.now, max_length=100, unique=True),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name='workshopchoice',
            name='workshop_officers',
            field=models.ForeignKey(help_text='Only users who are workshop practitioners can be assigned here.', limit_choices_to={'is_workshop_practitioner': True}, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='workshops', to='main.userprofile'),
        ),
    ]
