# Generated by Django 5.0.2 on 2024-10-10 17:05

import django.db.models.deletion
import django.utils.timezone
import django_ckeditor_5.fields
import main.models.UserProfile
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='AdminNotifications',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('message', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='Beneficiary',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Enter the full name of the beneficiary eg John Doe, Entebe primary school, Family childrens home, etc.', max_length=255)),
                ('location', models.CharField(help_text="Specify the geographical location of the beneficiaries. Example: 'Nairobi, Kenya, Kiserian, Kiambu, Loitoktok'.", max_length=255)),
                ('description', models.TextField(help_text="Provide additional details about the beneficiary. Example: 'A group of 25 young girls from Nunu primary school in Entebe rural area with limited access to education.'")),
                ('category', models.CharField(choices=[('Men', 'Men'), ('Women', 'Women'), ('Children', 'Children'), ('Disabled', 'Disabled'), ('Youth', 'Youth'), ('girls', 'girls'), ('boys', 'boys'), ('community', 'community'), ('employed', 'employed'), ('unemployed', 'unemployed'), ('students', 'students'), ('entreprenurs', 'entrepreneurs'), ('farmers', 'farmers'), ('artisans', 'artisans'), ('Elderly', 'Elderly'), ('Refugees', 'Refugees'), ('Indigenous', 'Indigenous'), ('Homeless', 'Homeless'), ('Other', 'Other')], help_text='Choose the category that best describes the beneficiary group.', max_length=50)),
                ('priority', models.CharField(choices=[('High', 'High'), ('Medium', 'Medium'), ('Low', 'Low'), ('Critical', 'Critical'), ('Urgent', 'Urgent'), ('Normal', 'Normal')], help_text='Choose the priority level assigned to the beneficiary group.', max_length=10)),
                ('strength', models.TextField(help_text="Describe the strengths of the beneficiary group. Example: 'Strong community leadership.'")),
                ('weakness', models.TextField(help_text="Describe the weaknesses or challenges faced by the beneficiary group. Example: 'Limited financial resources.'")),
                ('opportunities', models.TextField(help_text="List opportunities available to the beneficiary group. Example: 'Access to government grants.'")),
                ('threats', models.TextField(help_text="List threats or risks faced by the beneficiary group. Example: 'Political instability in the region.'")),
                ('needs', models.TextField(help_text="Outline the needs of the beneficiary group. Example: 'Access to healthcare services.'")),
                ('when_to_engage', models.TextField(help_text="Specify the appropriate times or phases during the project when the beneficiary group should be engaged. Example: 'During the initial planning phase.'")),
                ('how_to_engage', models.TextField(help_text="Describe the methods or approaches for engaging with the beneficiary group. Example: 'Community meetings and focus group discussions.'")),
                ('engagement_channels', models.TextField(help_text="List the communication channels to be used for engaging with the beneficiary group. Example: 'Email, SMS, in-person meetings.'")),
                ('engagement_frequency', models.TextField(help_text="Specify how often the beneficiary group will be engaged. Example: 'Monthly check-ins.'")),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
            ],
            options={
                'verbose_name': 'Project Beneficiary',
                'verbose_name_plural': 'Project Beneficiaries',
            },
        ),
        migrations.CreateModel(
            name='Calendar',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Enter the title of the calendar event.', max_length=255)),
                ('start', models.DateTimeField(help_text="Enter the start date and time for the calendar event. Example: '2024-09-01 09:00'.")),
                ('end', models.DateTimeField(help_text="Enter the end date and time for the calendar event. Example: '2024-09-01 17:00'.")),
                ('color_code', models.CharField(choices=[('Primary', 'Primary'), ('Info', 'Info'), ('Success', 'Success'), ('Danger', 'Danger')], help_text="Choose a color code to represent the event. Example: 'Primary' for default styling.", max_length=10)),
                ('badge', models.CharField(choices=[('Milestone', 'Milestone'), ('Activity', 'Activity')], help_text="Choose a badge to be displayed with the event. Example: 'Milestone'.", max_length=10)),
                ('description', models.TextField(help_text="Enter a description for the calendar event. Example: 'Community Health Training Session'.")),
                ('volunteers_summary', models.TextField(blank=True, help_text='Summary of volunteers by type.')),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Najimudu Event Calendar',
                'verbose_name_plural': 'Najimudu Events Calendar',
            },
        ),
        migrations.CreateModel(
            name='ContactAdminMessages',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=50)),
                ('email', models.EmailField(max_length=50)),
                ('phone', models.CharField(max_length=50)),
                ('message', models.CharField(max_length=255)),
                ('request_date', models.DateField(auto_now_add=True)),
                ('seen', models.BooleanField(default=False)),
                ('seen_date', models.DateField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'Admin Contact Message',
                'verbose_name_plural': 'Admin Contact Messages',
            },
        ),
        migrations.CreateModel(
            name='CoreProblem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="Enter the name of the core problem. Example: 'Lack of access to clean water'.", max_length=255)),
                ('description', models.TextField(help_text="Provide a detailed description of the core problem. Example: 'Communities in rural areas have limited access to clean drinking water, leading to health issues.'.")),
                ('driver', models.TextField(help_text="Identify the key drivers contributing to the core problem. Example: 'Poor infrastructure, limited government support'.")),
                ('root_causes', models.TextField(help_text="List the root causes of the core problem. Example: 'Geographic isolation, lack of investment in water systems'.")),
                ('effects', models.TextField(help_text="Describe the effects of the core problem on the community or environment. Example: 'Increased incidence of waterborne diseases'.")),
                ('impact', models.TextField(help_text="Describe the broader impact of the core problem. Example: 'Reduced quality of life, economic strain'.")),
                ('assumption', models.TextField(help_text="List any assumptions related to addressing the core problem. Example: 'Assume that community members are willing to adopt new water practices'.")),
                ('opportunity', models.TextField(help_text="Identify any opportunities that could help address the core problem. Example: 'Potential partnerships with NGOs'.")),
                ('constraints', models.TextField(help_text="List any constraints or barriers to solving the core problem. Example: 'Limited funding, lack of skilled labor'.")),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
            ],
            options={
                'verbose_name': 'Project Core Problem',
                'verbose_name_plural': 'Project Core Problems',
            },
        ),
        migrations.CreateModel(
            name='Indicator',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="Enter the name of the indicator. Example: 'Increase in literacy rate'.", max_length=255)),
                ('description', models.TextField(help_text="Provide a detailed description of the indicator. Example: 'This indicator measures the percentage increase in literacy among adults.'")),
                ('measure_type', models.CharField(choices=[('Quantitative', 'Quantitative: Measures that are numeric and can be counted or measured. Examples include percentages, ratios, and rates.'), ('Qualitative', 'Qualitative: Measures that describe qualities or characteristics. Examples include levels of satisfaction, opinions, and perceptions.')], help_text='Choose whether the measure is quantitative or qualitative.', max_length=15)),
                ('measure_unit', models.CharField(choices=[('Percentage', 'Percentage: Represents a portion out of 100. Example: 75% satisfaction.'), ('Rate', 'Rate: A measure of how frequently something occurs. Example: 5 events per month.'), ('Ratio', 'Ratio: A quantitative relationship between two numbers. Example: 3:1 ratio of success to failure.'), ('Opinion', 'Opinion: A subjective measure reflecting personal views or beliefs. Example: Survey responses about preferences.'), ('Perception', 'Perception: A qualitative measure of how people perceive or view something. Example: Public perception of a service.'), ('Level of Satisfaction', 'Level of Satisfaction: A qualitative measure of how satisfied individuals are, often using scales. Example: High, Medium, Low.')], help_text="Choose the unit of measure for this indicator. Example: '%', 'Ratio', 'Level of Satisfaction', etc.", max_length=50)),
                ('data_source', models.CharField(blank=True, choices=[('Survey', 'Survey: Data collected through surveys or questionnaires.'), ('Reports', 'Reports: Data derived from published reports or studies.'), ('Focus Groups', 'Focus Groups: Data collected from group discussions or focus groups.'), ('Case Studies', 'Case Studies: Detailed examinations of specific instances or examples.'), ('Interviews', 'Interviews: Data collected through structured or semi-structured interviews.'), ('Experimental Data', 'Experimental Data: Data derived from controlled experiments or trials.'), ('Statistical Data', 'Statistical Data: Data collected and analyzed using statistical methods.'), ('Benchmarking', 'Benchmarking: Data obtained by comparing against standards or best practices.'), ('Public Records', 'Public Records: Data obtained from publicly available records or documents.'), ('Field Observations', 'Field Observations: Data collected through direct observations in the field.'), ('Expert Assessments', 'Expert Assessments: Data gathered from evaluations by subject matter experts.'), ('Administrative Data', 'Administrative Data: Data collected by government or other administrative bodies.'), ('Digital Analytics', 'Digital Analytics: Data collected from digital platforms, such as website or app usage.'), ('Other', 'Other: Any other sources not listed here.')], help_text="Specify the source of data used for this indicator. Example: 'Survey', 'Administrative Data'.", max_length=50, null=True)),
                ('baseline', models.CharField(blank=True, help_text="Enter the baseline value before the intervention. For quantitative, example: '50%' for a literacy rate; for qualitative, example: 'Low satisfaction'.", max_length=255, null=True)),
                ('target', models.CharField(blank=True, help_text="Enter the target value that is hoped to be achieved. For quantitative, example: '75%' for a literacy rate; for qualitative, example: 'High satisfaction'.", max_length=255, null=True)),
                ('is_target_achieved', models.BooleanField(default=False, help_text="Indicate whether the target for this indicator has been achieved. Example: 'True' if the target value has been met or exceeded.")),
                ('achieved_value', models.CharField(blank=True, help_text="Enter the achieved value. For quantitative, example: '70%' for a literacy rate; for qualitative, example: 'Moderate satisfaction'.", max_length=255, null=True)),
                ('notes', models.TextField(blank=True, help_text="Describe any lessons learned from the process of achieving (or not achieving) this indicator. Example: 'Need to increase community engagement for better outcomes.'", null=True)),
                ('relevance', models.TextField(help_text="Explain how this indicator is relevant to the subject and evaluation. Example: 'Relevant to assessing the impact of education programs on literacy.'")),
                ('adequacy', models.TextField(help_text="Describe how this indicator provides sufficient information on performance. Example: 'Adequate to determine the effectiveness of the literacy program.'")),
                ('economic', models.BooleanField(default=True, help_text="Indicate whether this indicator can be measured at a reasonable cost. Example: 'True' for an indicator that uses readily available data.")),
                ('monitorable', models.BooleanField(default=True, help_text="Indicate whether this indicator is easily monitored and amenable to independent validation. Example: 'True' if the data can be independently verified.")),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
            ],
            options={
                'verbose_name': 'Project Indicator',
                'verbose_name_plural': 'Project Indicators',
            },
        ),
        migrations.CreateModel(
            name='OrganizationFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the file', max_length=255)),
                ('file', models.FileField(help_text='File to be uploaded', upload_to='organization_files/')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, help_text='Date the file was uploaded')),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('slug', models.SlugField(blank=True, unique=True)),
            ],
            options={
                'verbose_name': 'Najimudu Organization File',
                'verbose_name_plural': 'Najimudu Organization Files',
            },
        ),
        migrations.CreateModel(
            name='OrganizationType',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(choices=[('NGO', 'Non-Governmental Organization'), ('CHARITY', 'Charity'), ('FOUNDATION', 'Foundation'), ('GOVERNMENT_AGENCY', 'Government Agency'), ('TRUST', 'Trust'), ('INSTITUTE', 'Institute'), ('ASSOCIATION', 'Association'), ('COOPERATIVE', 'Cooperative'), ('SOCIAL_ENTERPRISE', 'Social Enterprise'), ('ADVOCACY_GROUP', 'Advocacy Group'), ('RESEARCH_ORG', 'Research Organization'), ('CBO', 'Community-Based Organization'), ('SOCIETY', 'Society'), ('CLUB', 'Club'), ('UNION', 'Union'), ('FOR_PROFIT', 'For Profit Organizations'), ('COMPANY', 'Companies'), ('SOLE_PROPRIETARY', 'Sole Proprietary Businesses'), ('OTHER', 'Other Types of Organizations Not Listed')], help_text='Select the type of organization', max_length=100, unique=True)),
                ('acronym', models.CharField(blank=True, editable=False, help_text='THIS FIELD IS AUTO FILLED', max_length=30)),
                ('description', models.TextField(blank=True, editable=False, help_text='THIS FIELD IS AUTO FILLED')),
                ('slug', models.SlugField(blank=True, editable=False, unique=True)),
            ],
            options={
                'verbose_name': 'Default-Organization Type',
                'verbose_name_plural': 'Default-Organization Types',
            },
        ),
        migrations.CreateModel(
            name='PartnershipAgreement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('document', models.FileField(upload_to='partnership_agreement/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Doc-Partnership Agreement',
                'verbose_name_plural': 'Doc-Partnership Agreement',
            },
        ),
        migrations.CreateModel(
            name='PrivacyPolicy',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('document', models.FileField(upload_to='privacy_policy/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Doc-Privacy Policy',
                'verbose_name_plural': 'Doc-Privacy Policy',
            },
        ),
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="Enter the name of the resource. Example: 'Projector'.", max_length=255)),
                ('number', models.IntegerField(help_text="Specify the quantity of the resource required. Example: '2'.")),
                ('unit_cost', models.DecimalField(decimal_places=2, help_text="Enter the unit cost of the resource. Example: '500.00'.", max_digits=10)),
                ('total_cost', models.DecimalField(decimal_places=2, help_text='This field is auto-calculated based on the number and unit cost.', max_digits=15)),
                ('use_function', models.TextField(help_text="Describe the use or function of the resource within the project. Example: 'Used for presentations during training sessions.'")),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
            ],
            options={
                'verbose_name': 'Project Resource',
                'verbose_name_plural': 'Project Resources',
            },
        ),
        migrations.CreateModel(
            name='SupportDocument',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('file', models.FileField(upload_to='support_documents/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='TermsAndConditions',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('document', models.FileField(upload_to='terms_and_conditions/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Doc-Terms and Conditions',
                'verbose_name_plural': 'Doc-Terms and Conditions',
            },
        ),
        migrations.CreateModel(
            name='Volunteer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100)),
                ('email', models.EmailField(max_length=254)),
                ('phone', models.CharField(max_length=20)),
                ('profile_picture', models.ImageField(blank=True, upload_to='Volunteer profile_pictures/')),
                ('volunteer_type', models.CharField(choices=[('VIRTUAL', 'Remote Volunteer Opportunity'), ('LONG_TERM', 'Long-Term Volunteer Commitment'), ('SHORT_TERM', 'Short-Term Volunteer Commitment'), ('SPECIALIZED', 'Specialized Skill-Based Volunteer'), ('EVENT_BASED', 'Event-Based Volunteer Participation'), ('MENTORING', 'Mentorship and Guidance Volunteer'), ('ADVOCACY', 'Advocacy and Awareness Volunteer'), ('ADMINISTRATIVE', 'Administrative Support Volunteer'), ('Administrative Support Volunteer', 'Administrative Support Volunteer'), ('COMMUNITY_SERVICE', 'Community Service Volunteer'), ('RESEARCH', 'Research and Data Analysis Volunteer')], help_text='Select the type of volunteer', max_length=100)),
                ('start_date', models.DateField(blank=True, null=True)),
                ('end_date', models.DateField(blank=True, null=True)),
                ('additional_info', models.TextField(blank=True, help_text='Provide any relevant information about your capacities, special needs, or other details.', max_length=500)),
                ('is_active', models.BooleanField(default=False)),
                ('volunteer_agreement_accepted', models.BooleanField(default=False)),
                ('emergency_contact_name', models.CharField(max_length=100)),
                ('emergency_contact_phone', models.CharField(max_length=20)),
                ('emergency_contact_email', models.EmailField(blank=True, max_length=254)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('date_applied', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='VolunteerAgreement',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('document', models.FileField(upload_to='volunteer_agreement/')),
                ('uploaded_at', models.DateTimeField(auto_now_add=True)),
            ],
            options={
                'verbose_name': 'Doc-Volunteer Agreement',
                'verbose_name_plural': 'Doc-Volunteer Agreements',
            },
        ),
        migrations.CreateModel(
            name='WebData',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='Organization name', max_length=150)),
                ('mission', models.TextField(blank=True, help_text='Organization Mission')),
                ('vision', models.TextField(blank=True, help_text='Organization Vision')),
                ('goals', models.TextField(blank=True, help_text='Organization Goals')),
                ('email', models.EmailField(blank=True, help_text='Organization Phone Number', max_length=254)),
                ('phone', models.CharField(blank=True, help_text='Organization Phone Number', max_length=20)),
                ('maintenance_mode', models.BooleanField(default=False, help_text='Enable maintenance mode')),
            ],
            options={
                'verbose_name': 'Website Data',
                'verbose_name_plural': 'Website Data',
            },
        ),
        migrations.CreateModel(
            name='ActivityLog',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('action', models.CharField(help_text="Action performed, representing the activity. Example: 'Login'", max_length=255)),
                ('timestamp', models.DateTimeField(auto_now_add=True, help_text="Timestamp of when the activity occurred. Example: '2024-01-15 12:30:45'")),
                ('details', models.TextField(blank=True, help_text="Additional details about the activity. (Optional) Example: 'Successful login from IP: 192.168.0.1'", null=True)),
                ('ip_address', models.GenericIPAddressField(blank=True, help_text="IP address associated with the activity. (Optional) Example: '192.168.0.1'", null=True)),
                ('user_agent', models.CharField(blank=True, help_text="User agent information associated with the activity. (Optional) Example: 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.110 Safari/537.36'", max_length=255, null=True)),
                ('status_code', models.IntegerField(blank=True, help_text="HTTP status code associated with the activity. (Optional) Example: '200' for a successful request.", null=True)),
                ('user', models.ForeignKey(blank=True, help_text='The Activity Log record to a specific user in the system.', null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Activity',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="Enter the name of the activity. Example: 'Community Training on Health Education'.", max_length=255)),
                ('status', models.CharField(choices=[('Planned', 'Planned'), ('In Progress', 'In Progress'), ('Completed', 'Completed'), ('Delayed', 'Delayed'), ('Canceled', 'Canceled'), ('On Hold', 'On Hold'), ('Not Started', 'Not Started'), ('Reviewed', 'Reviewed'), ('Approved', 'Approved')], help_text='Choose the current status of the activity.', max_length=20)),
                ('start_date', models.DateField(help_text="Specify the start date of the activity. Example: '2024-08-01'.")),
                ('end_date', models.DateField(help_text="Specify the end date of the activity. Example: '2024-08-05'.")),
                ('goals_and_objectives', models.TextField(help_text="Define the goals and objectives of this activity. Example: 'Goal is to enhance community health literacy and objective is to train 100 community members on basic health practices.'")),
                ('inputs_needed', models.TextField(help_text="List the inputs required to carry out this activity. Example: 'Trainers, training materials, venue, equipment.'")),
                ('outputs_needed_to_achieve_outcomes', models.TextField(help_text="Specify the outputs needed to achieve the desired outcomes. Example: 'Trained community members, distributed health education materials.'")),
                ('outcomes_to_be_achieved', models.TextField(help_text="Describe the outcomes that this activity aims to achieve. Example: 'Improved health awareness among community members.'")),
                ('impact', models.TextField(help_text="Describe the long-term impact of this activity. Example: 'Reduction in preventable diseases in the community.'")),
                ('strategy', models.TextField(help_text="Outline the strategy for implementing this activity. Example: 'Collaborate with local health professionals and community leaders.'")),
                ('how_activity_will_be_carried_out', models.TextField(help_text="Explain how the activity will be executed. Example: 'Conduct workshops in community centers with the help of trained facilitators.'")),
                ('cost', models.DecimalField(decimal_places=2, help_text="Enter the total cost of the activity. Example: '1500.00'.", max_digits=15)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('beneficiaries', models.ManyToManyField(help_text='Choose beneficiaries of this activity.', to='main.beneficiary')),
                ('resources', models.ManyToManyField(help_text='Choose and allocate all resources required for this activity.', to='main.resource')),
            ],
            options={
                'verbose_name': 'Project Activity',
                'verbose_name_plural': 'Project Activities',
            },
        ),
        migrations.CreateModel(
            name='NotificationReadBy',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_read', models.BooleanField(default=False)),
                ('timestamp', models.DateTimeField(auto_now_add=True)),
                ('notification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='read_by_entries', to='main.adminnotifications')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='PartneringOrganization',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('logo', models.ImageField(upload_to='Partnering_Organizations_logos/')),
                ('name', models.CharField(max_length=100)),
                ('description', models.TextField()),
                ('website_link', models.URLField(blank=True, help_text='Enter the link to the source of the funding opportunity (e.g., official website, announcement page, etc.).', null=True)),
                ('role_in_project', models.TextField(blank=True, null=True)),
                ('strategic_importance', models.TextField(blank=True, null=True)),
                ('resource_and_contribution', models.TextField(blank=True, null=True)),
                ('is_verified', models.BooleanField(default=False)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=500, unique=True)),
                ('type', models.ForeignKey(default=None, on_delete=django.db.models.deletion.SET_DEFAULT, related_name='partnering_organizations', to='main.organizationtype')),
                ('letter_of_support', models.ManyToManyField(blank=True, help_text='Letters from partnering local NGOs expressing their support and commitment to collaborating on the Project.', related_name='Letter_of_Support', to='main.supportdocument')),
                ('partnership_document', models.ManyToManyField(blank=True, help_text='Upload documents to verify the partnership eg M.O.U, etc', related_name='Partnership_Document', to='main.supportdocument')),
            ],
            options={
                'verbose_name': 'Najimudu Partnering Organization',
                'verbose_name_plural': 'Najimudu Partnering Organizations',
            },
        ),
        migrations.CreateModel(
            name='Stakeholder',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Enter the full name of the stakeholder eg John Doe, Entebe primary school, Family childrens home, etc.', max_length=255)),
                ('location', models.CharField(help_text="Specify the geographical location of the stakeholders. Example: 'Nairobi, Kenya, Kiserian, Kiambu, Loitoktok'.", max_length=255)),
                ('description', models.TextField(help_text="Provide additional details about the stakeholder. Example: 'Jane is a community leader involved in youth empowerment initiatives.'")),
                ('strength', models.TextField(help_text="Describe the strengths of the stakeholder. Example: 'Strong networking skills and community influence.'")),
                ('contribution', models.TextField(help_text="Describe the contribution of the stakeholder to the project. Example: 'Providing Networking support and community mobilization.'")),
                ('expectations', models.TextField(help_text="List expectations of the stakeholder. Example: 'Timely project updates and involvement in decision-making processes.'")),
                ('interests', models.TextField(help_text="Outline the interests and goals of the stakeholder. Example: 'Improving educational opportunities for underprivileged children.'")),
                ('affect_project', models.IntegerField(choices=[(1, 'No impact'), (2, 'Minimal impact'), (3, 'Moderate impact'), (4, 'Significant impact'), (5, 'Critical impact')], help_text='Rate how much the stakeholder influences the overall project. 1 = No impact, 5 = Critical impact.')),
                ('affected_by_project', models.IntegerField(choices=[(1, 'Not affected'), (2, 'Slightly affected'), (3, 'Moderately affected'), (4, 'Significantly affected'), (5, 'Highly affected')], help_text="Rate how much the stakeholder is affected by the project's activities. 1 = Not affected, 5 = Highly affected.")),
                ('affect_project_results', models.IntegerField(choices=[(1, 'No influence on results'), (2, 'Minor influence on results'), (3, 'Moderate influence on results'), (4, 'Strong influence on results'), (5, 'Decisive influence on results')], help_text='Rate how much the stakeholder influences the results or outcomes of the project. 1 = No influence on results, 5 = Decisive influence on results.')),
                ('affected_by_project_results', models.IntegerField(choices=[(1, 'No impact by results'), (2, 'Minimal impact by results'), (3, 'Moderate impact by results'), (4, 'Significant impact by results'), (5, 'Critical impact by results')], help_text='Rate how much the stakeholder is affected by the results or outcomes of the project. 1 = No impact by results, 5 = Critical impact by results.')),
                ('gain_from_project', models.TextField(help_text='Describe what the stakeholder gains or benefits from the project.')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('orgnanization', models.ForeignKey(blank=True, help_text='Choose the partnering organization of the stakeholder.', null=True, on_delete=django.db.models.deletion.CASCADE, to='main.partneringorganization')),
                ('support_document', models.ManyToManyField(blank=True, help_text='Upload documents to verify the cash received eg receipt, bank statement, etc', to='main.supportdocument')),
            ],
            options={
                'verbose_name': 'Project Stakeholder',
                'verbose_name_plural': 'Project Stakeholders',
            },
        ),
        migrations.CreateModel(
            name='SolutionTree',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('identified_solution', models.TextField(help_text="Describe the identified solution. Example: 'Implementing a water purification system'.")),
                ('solution_drivers', models.TextField(help_text="List the key drivers that support this solution. Example: 'Community demand, availability of resources'.")),
                ('strategy', models.TextField(help_text="Outline the strategy for implementing the solution. Example: 'Partnership with local organizations'.")),
                ('inputs', models.TextField(help_text="Specify the inputs required for the solution. Example: 'Funding, technical expertise'.")),
                ('outputs', models.TextField(help_text="Describe the expected outputs. Example: 'Number of water purification units installed'.")),
                ('outcomes', models.TextField(help_text="Describe the expected outcomes. Example: 'Improved access to clean water'.")),
                ('impact', models.TextField(help_text="Describe the long-term impact of the solution. Example: 'Reduction in waterborne diseases'.")),
                ('sustainability_plan', models.TextField(blank=True, help_text="Describe the sustainability plan or strategy to ensure long-term impact. Example: 'Training local staff, creating a maintenance fund, community ownership'.", null=True)),
                ('expected_results', models.TextField(help_text="Describe the results achieved by the solution. Example: '1000 households with access to clean water'.")),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('beneficiaries', models.ManyToManyField(help_text='Choose beneficiaries of this Solution.', to='main.beneficiary')),
                ('core_problem', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='solution_trees', to='main.coreproblem')),
                ('stakeholders', models.ManyToManyField(help_text='Choose the stakeholders involved in the solution.', to='main.stakeholder')),
                ('support_document', models.ManyToManyField(blank=True, help_text='Upload supporting documents.', to='main.supportdocument')),
            ],
            options={
                'verbose_name': 'Project Solution Tree',
                'verbose_name_plural': 'Project Solution Trees',
            },
        ),
        migrations.CreateModel(
            name='Project',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(help_text='What is the Title of the project?', max_length=255)),
                ('description', django_ckeditor_5.fields.CKEditor5Field(help_text='What is the Project About?', verbose_name='Detailed Description')),
                ('category', models.CharField(choices=[('Proprietary', 'Proprietary'), ('Collaborative', 'Collaborative')], default='Collaborative', max_length=20, unique=True)),
                ('status', models.CharField(choices=[('Pending', 'Pending'), ('Completed', 'Completed'), ('In Progress', 'In Progress'), ('Not Started', 'Not Started')], default='Not Started', max_length=100)),
                ('donation_needed', models.DecimalField(blank=True, decimal_places=2, max_digits=15, null=True)),
                ('donation_raised', models.DecimalField(blank=True, decimal_places=2, max_digits=15, null=True)),
                ('project_cycle', models.CharField(choices=[('Design', 'Design'), ('Closure', 'Closure'), ('Control', 'Control'), ('Reporting', 'Reporting'), ('Monitoring', 'Monitoring'), ('Completion', 'Completion'), ('Evaluation', 'Evaluation'), ('Dissemination', 'Dissemination'), ('Identification', 'Identification'), ('Implementation', 'Implementation'), ('Pre-implementation', 'Pre-implementation'), ('Operational Planning and Budgeting', 'Operational Planning and Budgeting')], help_text='What is the Current project cycle stage ?.', max_length=100)),
                ('project_phase', models.CharField(choices=[('Research', 'Research'), ('Engagement', 'Engagement'), ('Analysis', 'Analysis'), ('Field Work', 'Field Work'), ('Planning', 'Planning'), ('Execution', 'Execution'), ('Review', 'Review')], help_text='What is the Current project phase?.', max_length=100)),
                ('problem_statement', django_ckeditor_5.fields.CKEditor5Field(blank=True, help_text='What are the Challanges and problem being faced ?.', null=True, verbose_name='Problem Statement')),
                ('problem_impact', django_ckeditor_5.fields.CKEditor5Field(blank=True, help_text='What are the Negative impacts and effects impacts of the project to environment and beneficiaries.?', null=True, verbose_name='Impact of the Problem')),
                ('project_goals', django_ckeditor_5.fields.CKEditor5Field(blank=True, help_text='What are the goals of the project ?.', null=True, verbose_name='Projected goals')),
                ('sustainability_plan', django_ckeditor_5.fields.CKEditor5Field(blank=True, help_text='What measures are in place to ensure the long-term sustainability and impact of the project?', null=True, verbose_name='Sustainability Plan')),
                ('views_count', models.PositiveIntegerField(default=0)),
                ('views_ips', models.JSONField(blank=True, default=list)),
                ('is_active', models.BooleanField(default=False)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=500, unique=True)),
                ('activities', models.ManyToManyField(blank=True, help_text='Choose the activities of this project.', to='main.activity')),
                ('beneficiaries', models.ManyToManyField(blank=True, help_text='Who are the Beneficiaries of the project?', to='main.beneficiary')),
                ('partners', models.ManyToManyField(blank=True, help_text='Who are the Partnering Organization in this project?', to='main.partneringorganization')),
                ('solution_trees', models.ManyToManyField(blank=True, help_text='Include solution trees related to this project.', to='main.solutiontree')),
                ('stakeholders', models.ManyToManyField(blank=True, help_text='Who are the Stakeholders of the project?', to='main.stakeholder')),
                ('project_document', models.ManyToManyField(blank=True, help_text='Upload documents related to the project initiative THAT DO NOT NEED UPDATE eg Last-report, analysis, awards, etc', to='main.supportdocument')),
            ],
            options={
                'verbose_name': 'Project',
                'verbose_name_plural': 'Project',
            },
        ),
        migrations.AddField(
            model_name='activity',
            name='stakeholders',
            field=models.ManyToManyField(help_text='Choose stakeholders involved in this activity.', to='main.stakeholder'),
        ),
        migrations.CreateModel(
            name='Result',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('output', models.TextField(help_text="Describe the specific output/impact produced by the intervention. Example: '100 community members trained on health practices.'")),
                ('outcome', models.TextField(help_text="Describe what has changed as a result of the intervention. Example: 'Increased awareness of health practices among trained community members.'")),
                ('results_achieved', models.TextField(help_text="Specify the results that have been achieved. Example: '80 percent of trained members are now practicing better health hygiene.'")),
                ('global_contribution', models.TextField(help_text="Describe how the result contributes to global goals or initiatives. Example: 'Contributes to the United Nations Sustainable Development Goal 3: Good Health and Well-being.'")),
                ('regional_contribution', models.TextField(help_text="Describe how the result contributes at a regional level. Example: 'Supports regional health initiatives across East Africa.'")),
                ('national_contribution', models.TextField(help_text="Describe how the result contributes at the national level. Example: 'Aligns with the National Health Strategy of Kenya.'")),
                ('local_level_contribution', models.TextField(help_text="Describe how the result contributes at the local level. Example: 'Enhances community health and reduces preventable diseases in the locality.'")),
                ('is_achieved', models.BooleanField(default=False, help_text="Has the result been achieved? Example: 'True' if achieved, 'False' otherwise.")),
                ('gender_inequities_addressed', models.BooleanField(default=False, help_text="Have gender inequities been addressed in achieving this result? Example: 'True' if addressed, 'False' otherwise.")),
                ('climate_change_addressed', models.BooleanField(default=False, help_text="Has climate change been addressed in achieving this result? Example: 'True' if addressed, 'False' otherwise.")),
                ('how_gender_inequities_addressed', models.TextField(blank=True, help_text="Explain how gender inequities have been addressed. Example: 'Promoted equal participation of women in training sessions.'", null=True)),
                ('how_climate_change_addressed', models.TextField(blank=True, help_text="Explain how climate change has been addressed. Example: 'Implemented eco-friendly practices during activities.'", null=True)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('evidence_of_change', models.ManyToManyField(help_text='Provide evidence of change/impact by linking relevant indicators, baselines, and targets.', to='main.indicator')),
                ('project', models.ForeignKey(help_text='Choose the project title associated with this result.', on_delete=django.db.models.deletion.CASCADE, related_name='results', to='main.project')),
                ('support_document', models.ManyToManyField(blank=True, help_text='Upload supporting documents that provide evidence of the results achieved.', to='main.supportdocument')),
            ],
            options={
                'verbose_name': 'Project Result',
                'verbose_name_plural': 'Project Results',
            },
        ),
        migrations.CreateModel(
            name='Milestone',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text="Enter the name of the milestone. Example: 'Completion of Phase 1'.", max_length=255)),
                ('description', models.TextField(blank=True, help_text="Enter a description for the the milestone. Example: 'The project has been completed and all outputs are available.'")),
                ('start_date', models.DateField(help_text='Specify the start date of the milestone.')),
                ('end_date', models.DateField(help_text='Specify the end date of the milestone.')),
                ('is_achieved', models.BooleanField(default=False, help_text="Indicate whether this milestone has been achieved. Example: 'True' if achieved, 'False' otherwise.")),
                ('date_of_achievement', models.DateField(blank=True, help_text="Enter the date when the milestone was achieved. Example: '2024-09-15'.", null=True)),
                ('cost', models.DecimalField(decimal_places=2, help_text="Enter the total cost associated with achieving this milestone. Example: '3000.00'.", max_digits=15)),
                ('slug', models.SlugField(blank=True, editable=False, max_length=255, unique=True)),
                ('project', models.ForeignKey(help_text='Choose the project for this milestone.', on_delete=django.db.models.deletion.CASCADE, related_name='milestones', to='main.project')),
                ('support_document', models.ManyToManyField(blank=True, help_text='Upload supporting documents.', to='main.supportdocument')),
            ],
            options={
                'verbose_name': 'Project Milestone',
                'verbose_name_plural': 'Project Milestones',
            },
        ),
        migrations.AddField(
            model_name='coreproblem',
            name='support_document',
            field=models.ManyToManyField(blank=True, help_text='Upload documents to identify the core problem eg image, video, report  etc', to='main.supportdocument'),
        ),
        migrations.AddField(
            model_name='beneficiary',
            name='support_document',
            field=models.ManyToManyField(blank=True, help_text='Upload documents to verify the cash received eg receipt, bank statement, etc', to='main.supportdocument'),
        ),
        migrations.AddField(
            model_name='activity',
            name='support_document',
            field=models.ManyToManyField(blank=True, help_text='Upload supporting documents.', to='main.supportdocument'),
        ),
        migrations.CreateModel(
            name='UserProfile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('profile_picture', models.ImageField(blank=True, upload_to='profile_pictures/')),
                ('phone', models.CharField(max_length=20)),
                ('bio', models.TextField(blank=True)),
                ('slug', models.SlugField(blank=True, editable=False, unique=True)),
                ('verification_token', models.CharField(blank=True, default=main.models.UserProfile.generate_verification_token, max_length=20, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('is_active', models.BooleanField(default=False)),
                ('is_verified', models.BooleanField(default=False)),
                ('resume_and_certifications', models.ManyToManyField(blank=True, help_text='Upload resumes, certificates, awards..etc', to='main.supportdocument')),
                ('user', models.OneToOneField(help_text="A one-to-one relationship with the default Logged in User. Example: 'You!'", on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.AddField(
            model_name='solutiontree',
            name='user_responsible',
            field=models.ForeignKey(blank=True, help_text='Choose the user responsible for overseeing the implementation of this solution.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='main.userprofile'),
        ),
        migrations.AddField(
            model_name='project',
            name='author',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='Project', to='main.userprofile'),
        ),
        migrations.CreateModel(
            name='ProgressReport',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=100)),
                ('progress_report_priority', models.CharField(choices=[('Completed', 'Completed'), ('Under-Review', 'Under-Review'), ('Not-Started', 'Not-Started')], default='Not-Started', max_length=20)),
                ('progress_report_tags', models.CharField(choices=[('Management', 'Management'), ('General', 'General'), ('Finance', 'Finance'), ('Program', 'Program')], default='General', max_length=20)),
                ('description', models.TextField(default=0)),
                ('modified_date', models.DateTimeField(auto_now=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('is_seen', models.BooleanField(default=False)),
                ('slug', models.SlugField(blank=True, editable=False, unique=True)),
                ('partnering_organization', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.partneringorganization')),
                ('project', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.project')),
                ('progress_report_document', models.ManyToManyField(blank=True, to='main.supportdocument')),
                ('seen_by', models.ManyToManyField(blank=True, related_name='seen_reports', to='main.userprofile')),
                ('user_assignee', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='assignee', to='main.userprofile')),
                ('user_profile', models.ForeignKey(default=None, on_delete=django.db.models.deletion.CASCADE, to='main.userprofile')),
                ('volunteer_profile', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='main.volunteer')),
            ],
            options={
                'verbose_name': 'Progress Report',
                'verbose_name_plural': 'Progress Reports',
            },
        ),
        migrations.CreateModel(
            name='Note',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=255)),
                ('description', models.TextField()),
                ('date', models.DateField(auto_now_add=True)),
                ('isFav', models.BooleanField(default=False)),
                ('tag', models.CharField(choices=[('Important', 'Important'), ('Completed', 'Completed'), ('Pending', 'Pending'), ('Stalled', 'Stalled'), ('Urgent', 'Urgent'), ('In Progress', 'In Progress'), ('On Hold', 'On Hold'), ('Deferred', 'Deferred'), ('Cancelled', 'Cancelled'), ('Assigned', 'Assigned'), ('Not Started', 'Not Started'), ('Under Review', 'Under Review'), ('Awaiting Approval', 'Awaiting Approval'), ('Unassigned', 'Unassigned')], max_length=20)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.userprofile')),
            ],
        ),
        migrations.CreateModel(
            name='Minutes',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('agenda', models.TextField(help_text='Agenda of the meeting')),
                ('minutes', django_ckeditor_5.fields.CKEditor5Field(verbose_name='Minutes of the meeting')),
                ('meeting_date', models.DateTimeField(help_text='Date and time of the meeting')),
                ('meeting_title', models.CharField(help_text='Title of the meeting', max_length=255)),
                ('attendees', models.TextField(help_text='List of attendees (comma-separated or as a text block)')),
                ('aobs', models.TextField(blank=True, help_text='Any Other Business (AOBs) discussed in the meeting')),
                ('previous_meeting_seconded_by', models.CharField(blank=True, help_text="Person who seconded the previous meeting's minutes", max_length=255)),
                ('members_absent_with_apologies', models.TextField(blank=True, help_text='List of members absent with apologies (comma-separated)')),
                ('members_absent_without_apologies', models.TextField(blank=True, help_text='List of members absent without apologies (comma-separated)')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now, help_text='Date when the minutes were created')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='Date when the minutes were last updated')),
                ('slug', models.SlugField(blank=True, help_text='Slug for clean URLs', unique=True)),
                ('file', models.ManyToManyField(blank=True, help_text='Upload Attach any documents shares/used in this meeting', to='main.supportdocument')),
                ('created_by', models.ForeignKey(help_text='User who created the minutes', null=True, on_delete=django.db.models.deletion.SET_NULL, to='main.userprofile')),
            ],
            options={
                'verbose_name': 'Najimudu Meeting Minute',
                'verbose_name_plural': 'Najimudu Meeting Minutes',
                'ordering': ['-meeting_date'],
            },
        ),
        migrations.CreateModel(
            name='ContactDeveloper',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('subject', models.CharField(max_length=255)),
                ('message', models.CharField(max_length=500)),
                ('request_date', models.DateField(auto_now_add=True)),
                ('seen', models.BooleanField(default=False)),
                ('seen_date', models.DateField(blank=True, null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.userprofile')),
            ],
            options={
                'verbose_name': 'Admin Contact Message',
                'verbose_name_plural': 'Admin Contact Messages',
            },
        ),
        migrations.AddField(
            model_name='activity',
            name='user_responsible',
            field=models.ForeignKey(blank=True, help_text='Choose the user responsible for overseeing the implementation of this activity.', null=True, on_delete=django.db.models.deletion.SET_NULL, to='main.userprofile'),
        ),
        migrations.CreateModel(
            name='UserFile',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(help_text='Name of the document', max_length=255)),
                ('file', models.FileField(help_text=' Private Document file to be uploaded', upload_to='user_documents/')),
                ('upload_date', models.DateTimeField(default=django.utils.timezone.now, help_text='Date the document was uploaded')),
                ('updated_at', models.DateTimeField(auto_now=True, help_text='Date the document was last updated')),
                ('slug', models.SlugField(blank=True, unique=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.userprofile')),
            ],
            options={
                'verbose_name': 'Najimudu User Personal Document',
                'verbose_name_plural': 'Najimudu User Personal Documents',
                'unique_together': {('user', 'name')},
            },
        ),
        migrations.CreateModel(
            name='UserReportStatus',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('status', models.CharField(choices=[('seen', 'Seen'), ('trash', 'Trash'), ('important', 'Important'), ('', 'Default')], default='', max_length=20)),
                ('report', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='main.progressreport')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'unique_together': {('user', 'report')},
            },
        ),
    ]
