from django.http import HttpResponseRedirect
from django.conf import settings
from .models.WebData import WebData

class MaintenanceMiddleware:
    def __init__(self, get_response):
        self.get_response = get_response

    def __call__(self, request):
        # Fetch the first instance of WebData
        webdata = WebData.objects.first()
        maintenance_mode_active = webdata.maintenance_mode if webdata else False
        
        # Allow access to admin URL path if in maintenance mode
        if maintenance_mode_active and not request.path_info.startswith('/Support/maintenance'):
            # Allow access to admin URL paths
            if request.path_info.startswith('/admin/'):
                return self.get_response(request)
            return HttpResponseRedirect('/Support/maintenance')

        response = self.get_response(request)
        return response
