import pandas as pd
from django.core.management.base import BaseCommand
from django.utils.dateparse import parse_date
from main.models import Volunteer  

class Command(BaseCommand):
    help = 'Import volunteers from an Excel spreadsheet.'

    def handle(self, *args, **kwargs):
        file_path = r'C:\Users\georg\OneDrive\Documents\2023 projects\clients\Najimudu\Najimudu Empowerment Initiative 2nd Edition Climate Health Camp Volunteer Registration(1-67).xlsx'

        try:
            # Load the Excel file
            df = pd.read_excel(file_path)

            # Rename columns to remove non-breaking spaces
            df.columns = df.columns.str.replace('\xa0', ' ')

            # Iterate over the rows, starting from the correct column
            for index, row in df.iterrows():
                try:
                    # Extract relevant columns
                    name = row['Full Name']
                    age = row['Age']
                    email = row['Email']
                    phone = row['WhatsApp']
                    whatsapp_number = row['WhatsApp']
                    student_status = 'STUDENT' if row['licensed'] == 'student' else 'LICENSED'
                    institution_of_study = row['Institution']
                    year_of_study = row['Year']
                    course_of_study = row['Course']
                    level_of_study = row['Level']
                    qualification = row['qualification']
                    is_registered_and_licensed = row['registered'] == 'Yes'
                    department = row['department']
                    available_date_str = row['available']
                    referral_source = row['opportunity']
                    professional_qualification = row['professionalqualification']
                    role_description = row['role']
                    can_provide_proof = row['required'] == 'Yes'

                    # Convert the available date string into a date field for start_date and end_date
                    start_date = parse_date(available_date_str) if available_date_str else None
                    end_date = start_date  # Using the same date for both start and end

                    # Create or update the Volunteer instance
                    volunteer, created = Volunteer.objects.update_or_create(
                        email=email,
                        defaults={
                            'name': name,
                            'age': age,
                            'phone': phone,
                            'whatsapp_number': whatsapp_number,
                            'student_status': student_status,
                            'institution_of_study': institution_of_study,
                            'year_of_study': year_of_study,
                            'course_of_study': course_of_study,
                            'level_of_study': level_of_study,
                            'qualification': qualification,
                            'is_registered_and_licensed': is_registered_and_licensed,
                            'department': department,
                            'start_date': start_date,
                            'end_date': end_date,
                            'referral_source': referral_source,
                            'professional_qualification': professional_qualification,
                            'role_description': role_description,
                            'can_provide_proof': can_provide_proof,
                        }
                    )

                    if created:
                        self.stdout.write(self.style.SUCCESS(f'Successfully created volunteer: {name}'))
                    else:
                        self.stdout.write(self.style.SUCCESS(f'Updated volunteer: {name}'))

                except Exception as e:
                    self.stdout.write(self.style.ERROR(f"Error processing row {index}: {e}"))

        except Exception as e:
            self.stdout.write(self.style.ERROR(f"Failed to load file: {e}"))
